/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.google.common.collect.Maps;
import com.samskivert.swing.RadialMenu;
import com.samskivert.util.StringUtil;
import com.threerings.miso.Log;
import com.threerings.miso.client.MisoScenePanel;
import com.threerings.miso.client.SceneObject;
import com.threerings.miso.client.SceneObjectIndicator;
import com.threerings.miso.client.SceneObjectTip;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.Icon;

public class ObjectActionHandler {
    protected static HashMap<String, ObjectActionHandler> _oahandlers = Maps.newHashMap();

    public boolean actionAllowed(String action) {
        return true;
    }

    public boolean isVisible(String action) {
        return this.actionAllowed(action);
    }

    public String getTipText(String action) {
        return action;
    }

    public Icon getTipIcon(String action) {
        return null;
    }

    public RadialMenu handlePressed(SceneObject sourceObject) {
        return null;
    }

    public void handleAction(SceneObject scobj, ActionEvent event) {
        Log.log.warning((Object)"Unknown object action", new Object[]{"scobj", scobj, "action", event});
    }

    public static String getType(String command) {
        int cidx = StringUtil.isBlank((String)command) ? -1 : command.indexOf(58);
        return cidx == -1 ? "" : command.substring(0, cidx);
    }

    public static String getAction(String command) {
        int cidx = StringUtil.isBlank((String)command) ? -1 : command.indexOf(58);
        return cidx == -1 ? command : command.substring(cidx + 1);
    }

    public SceneObjectIndicator createIndicator(MisoScenePanel panel, String text, Icon icon) {
        return new SceneObjectTip(text, icon);
    }

    public static ObjectActionHandler lookup(String command) {
        return _oahandlers.get(ObjectActionHandler.getType(command));
    }

    public static void register(String prefix, ObjectActionHandler handler) {
        if (_oahandlers.containsKey(prefix)) {
            Log.log.warning((Object)"Warning! Overwriting previous object action handler registration, all hell could shortly break loose", new Object[]{"prefix", prefix, "handler", handler});
        }
        _oahandlers.put(prefix, handler);
    }

    public static void unregister(String prefix) {
        _oahandlers.remove(prefix);
    }
}

