/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

public abstract class TimeFunction {
    protected int _start;
    protected int _end;
    protected int _duration;
    protected long _startStamp;

    public TimeFunction(int start, int end, int duration) {
        this._start = start;
        this._end = end;
        this._duration = duration;
    }

    public void init(long tickStamp) {
        this._startStamp = tickStamp;
    }

    public void fastForward(long timeDelta) {
        this._startStamp += timeDelta;
    }

    public int getValue(long tickStamp) {
        int dt;
        if (this._startStamp == 0L) {
            this._startStamp = tickStamp;
        }
        if ((dt = (int)(tickStamp - this._startStamp)) <= 0) {
            return this._start;
        }
        if (dt >= this._duration) {
            return this._end;
        }
        return this.computeValue(dt);
    }

    protected abstract int computeValue(int var1);
}

