/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.google.common.collect.Maps;
import com.threerings.media.Log;
import com.threerings.media.timer.MediaTimer;
import com.threerings.media.timer.NanoTimer;
import com.threerings.media.util.PerformanceAction;
import com.threerings.media.util.PerformanceObserver;
import java.util.HashMap;
import java.util.Map;

public class PerformanceMonitor {
    protected static Map<PerformanceObserver, Map<String, PerformanceAction>> _observers = Maps.newHashMap();
    protected static MediaTimer _timer = new NanoTimer();

    public static void register(PerformanceObserver obs, String name, long delta) {
        HashMap actions = _observers.get(obs);
        if (actions == null) {
            actions = Maps.newHashMap();
            _observers.put(obs, actions);
        }
        actions.put(name, new PerformanceAction(obs, name, delta));
    }

    public static void unregister(PerformanceObserver obs, String name) {
        Map<String, PerformanceAction> actions = _observers.get(obs);
        if (actions == null) {
            Log.log.warning((Object)("Attempt to unregister by unknown observer [observer=" + obs + ", name=" + name + "]."), new Object[0]);
            return;
        }
        PerformanceAction action = actions.remove(name);
        if (action == null) {
            Log.log.warning((Object)("Attempt to unregister unknown action [observer=" + obs + ", name=" + name + "]."), new Object[0]);
            return;
        }
        if (actions.size() == 0) {
            _observers.remove(obs);
        }
    }

    public static void tick(PerformanceObserver obs, String name) {
        Map<String, PerformanceAction> actions = _observers.get(obs);
        if (actions == null) {
            Log.log.warning((Object)("Attempt to tick by unknown observer [observer=" + obs + ", name=" + name + "]."), new Object[0]);
            return;
        }
        PerformanceAction action = actions.get(name);
        if (action == null) {
            Log.log.warning((Object)("Attempt to tick unknown value [observer=" + obs + ", name=" + name + "]."), new Object[0]);
            return;
        }
        action.tick();
    }

    public static void setMediaTimer(MediaTimer timer) {
        _timer = timer;
    }

    protected static synchronized long getTimeStamp() {
        return _timer.getElapsedMillis();
    }
}

