/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.threerings.media.util.PerformanceMonitor;
import com.threerings.media.util.PerformanceObserver;

class PerformanceAction {
    protected PerformanceObserver _obs;
    protected String _name;
    protected long _delta;
    protected long _lastDelta;
    protected int _numTicks;

    public PerformanceAction(PerformanceObserver obs, String name, long delta) {
        this._obs = obs;
        this._name = name;
        this._delta = delta;
        this._lastDelta = PerformanceMonitor.getTimeStamp();
    }

    public void tick() {
        ++this._numTicks;
        long now = PerformanceMonitor.getTimeStamp();
        long passed = now - this._lastDelta;
        if (passed >= this._delta) {
            this._lastDelta = now + (passed - this._delta);
            this._obs.checkpoint(this._name, this._numTicks);
            this._numTicks = 0;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[obs=").append(this._obs);
        buf.append(", name=").append(this._name);
        buf.append(", delta=").append(this._delta);
        buf.append(", lastDelta=").append(this._lastDelta);
        buf.append(", numTicks=").append(this._numTicks);
        return buf.append("]").toString();
    }
}

