/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import java.awt.Point;

public class MathUtil {
    public static int bound(int low, int value, int high) {
        return Math.min(high, Math.max(low, value));
    }

    public static int distanceSq(int x0, int y0, int x1, int y1) {
        return (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
    }

    public static float distance(int x0, int y0, int x1, int y1) {
        return (float)Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
    }

    public static float distance(Point source, Point dest) {
        return MathUtil.distance(source.x, source.y, dest.x, dest.y);
    }

    public static String lineToString(int x0, int y0, int x1, int y1) {
        return "(" + x0 + ", " + y0 + ") -> (" + x1 + ", " + y1 + ")";
    }

    public static String lineToString(Point p1, Point p2) {
        return MathUtil.lineToString(p1.x, p1.y, p2.x, p2.y);
    }

    public static double ellipseCircum(double a, double b) {
        return Math.PI * (3.0 * a + 3.0 * b - Math.sqrt((a + 3.0 * b) * (b + 3.0 * a)));
    }

    public static int sign(int value) {
        return value < 0 ? -1 : 1;
    }

    public static int floorDiv(int dividend, int divisor) {
        return dividend >= 0 == divisor >= 0 ? dividend / divisor : (divisor >= 0 ? (dividend - divisor + 1) / divisor : (dividend - divisor - 1) / divisor);
    }

    public static float[] stddev(int[] values, int start, int length) {
        float mean = 0.0f;
        int end = start + length;
        for (int ii = start; ii < end; ++ii) {
            mean += (float)values[ii];
        }
        mean /= (float)length;
        float variance = 0.0f;
        int end2 = start + length;
        for (int ii = start; ii < end2; ++ii) {
            float value = (float)values[ii] - mean;
            variance += value * value;
        }
        return new float[]{mean, variance /= (float)(length - 1), (float)Math.sqrt(variance)};
    }

    public static int choose(int n, int k) {
        if (k <= 0 || k >= n) {
            return 1;
        }
        return MathUtil.choose(n - 1, k - 1) + MathUtil.choose(n - 1, k);
    }
}

