/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.google.common.collect.Lists;
import com.samskivert.util.StringUtil;
import com.threerings.media.Log;
import com.threerings.media.util.MathUtil;
import com.threerings.media.util.Path;
import com.threerings.media.util.PathNode;
import com.threerings.media.util.Pathable;
import com.threerings.util.DirectionCodes;
import com.threerings.util.DirectionUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineSegmentPath
implements DirectionCodes,
Path {
    protected ArrayList<PathNode> _nodes = Lists.newArrayList();
    protected Iterator<PathNode> _niter;
    protected PathNode _src;
    protected PathNode _dest;
    protected long _nodestamp;
    protected float _seglength;
    protected float _vel = 0.2f;
    protected float _movex;
    protected float _movey;
    protected float _incx;
    protected float _incy;
    protected float _fracx;
    protected float _fracy;
    protected static final float DEFAULT_VELOCITY = 0.2f;

    public LineSegmentPath() {
    }

    public LineSegmentPath(int x1, int y1, int x2, int y2) {
        this.addNode(x1, y1, 3);
        Point p1 = new Point(x1, y1);
        Point p2 = new Point(x2, y2);
        int dir = DirectionUtil.getDirection(p1, p2);
        this.addNode(x2, y2, dir);
    }

    public LineSegmentPath(Point p1, Point p2, int dir) {
        this.addNode(p1.x, p1.y, 3);
        this.addNode(p2.x, p2.y, dir);
    }

    public LineSegmentPath(List<Point> points) {
        this.createPath(points);
    }

    public int getFinalOrientation() {
        return this._nodes.size() == 0 ? 3 : this._nodes.get((int)(this._nodes.size() - 1)).dir;
    }

    public void addNode(int x, int y, int dir) {
        this._nodes.add(new PathNode(x, y, dir));
    }

    public PathNode getNode(int idx) {
        return this._nodes.get(idx);
    }

    public int size() {
        return this._nodes.size();
    }

    public void setVelocity(float velocity) {
        this._vel = velocity;
    }

    public void setDuration(long millis) {
        int ncount = this._nodes.size();
        if (ncount < 2) {
            Log.log.warning((Object)"Requested to set duration of bogus path", new Object[]{"path", this, "duration", millis});
            return;
        }
        float distance = 0.0f;
        PathNode start = this._nodes.get(0);
        for (int ii = 1; ii < ncount; ++ii) {
            PathNode end = this._nodes.get(ii);
            distance += MathUtil.distance(start.loc.x, start.loc.y, end.loc.x, end.loc.y);
            start = end;
        }
        this.setVelocity(distance / (float)millis);
    }

    @Override
    public void init(Pathable pable, long timestamp) {
        pable.pathBeginning();
        if (this.size() < 2) {
            if (this.size() == 1) {
                PathNode node = this._nodes.get(0);
                pable.setLocation(node.loc.x, node.loc.y);
            }
            pable.pathCompleted(timestamp);
            return;
        }
        this._niter = this._nodes.iterator();
        this._dest = this.getNextNode();
        this.headToNextNode(pable, timestamp, timestamp);
    }

    @Override
    public boolean tick(Pathable pable, long timestamp) {
        long msecs = timestamp - this._nodestamp;
        float travpix = (float)msecs * this._vel;
        float pctdone = travpix / this._seglength;
        if ((double)pctdone >= 1.0) {
            long used = (long)(this._seglength / this._vel);
            return this.headToNextNode(pable, this._nodestamp + used, timestamp);
        }
        int ox = pable.getX();
        int oy = pable.getY();
        int nx = this._src.loc.x + (int)((float)(this._dest.loc.x - this._src.loc.x) * pctdone);
        int ny = this._src.loc.y + (int)((float)(this._dest.loc.y - this._src.loc.y) * pctdone);
        if (ox != nx || oy != ny) {
            pable.setLocation(nx, ny);
            return true;
        }
        return false;
    }

    @Override
    public void fastForward(long timeDelta) {
        this._nodestamp += timeDelta;
    }

    @Override
    public void wasRemoved(Pathable pable) {
    }

    protected boolean headToNextNode(Pathable pable, long startstamp, long now) {
        if (this._niter == null) {
            throw new IllegalStateException("headToNextNode() called before init()");
        }
        if (!this._niter.hasNext()) {
            pable.setLocation(this._dest.loc.x, this._dest.loc.y);
            pable.pathCompleted(now);
            return true;
        }
        this._src = this._dest;
        this._dest = this.getNextNode();
        if (this._dest.dir != -1) {
            pable.setOrientation(this._dest.dir);
        }
        this._nodestamp = startstamp;
        this._seglength = MathUtil.distance(this._src.loc.x, this._src.loc.y, this._dest.loc.x, this._dest.loc.y);
        if (this._seglength == 0.0f) {
            return this.headToNextNode(pable, startstamp, now);
        }
        return this.tick(pable, now);
    }

    @Override
    public void paint(Graphics2D gfx) {
        gfx.setColor(Color.red);
        Point prev = null;
        int size = this.size();
        for (int ii = 0; ii < size; ++ii) {
            PathNode n = this.getNode(ii);
            if (prev != null) {
                gfx.drawLine(prev.x, prev.y, n.loc.x, n.loc.y);
            }
            prev = n.loc;
        }
    }

    public String toString() {
        return StringUtil.toString(this._nodes.iterator());
    }

    protected void createPath(List<Point> points) {
        Point last = null;
        int size = points.size();
        for (int ii = 0; ii < size; ++ii) {
            Point p = points.get(ii);
            int dir = ii == 0 ? 3 : DirectionUtil.getDirection(last, p);
            this.addNode(p.x, p.y, dir);
            last = p;
        }
    }

    protected PathNode getNextNode() {
        return this._niter.next();
    }
}

