/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.threerings.media.util.MultiFrameImage;

public interface FrameSequencer {
    public int init(MultiFrameImage var1);

    public int tick(long var1);

    public void fastForward(long var1);

    public static class ConstantRate
    implements FrameSequencer {
        protected long _millisPerFrame;
        protected boolean _loop;
        protected int _frameCount;
        protected long _startStamp;

        public ConstantRate(double framesPerSecond, boolean loop) {
            this._millisPerFrame = (long)(1000.0 / framesPerSecond);
            this._loop = loop;
        }

        public int init(MultiFrameImage source) {
            this._frameCount = source.getFrameCount();
            this._startStamp = 0L;
            return 0;
        }

        public int tick(long tickStamp) {
            if (this._startStamp == 0L) {
                this._startStamp = tickStamp;
            }
            int frameIdx = (int)((tickStamp - this._startStamp) / this._millisPerFrame);
            return this._loop || frameIdx < this._frameCount ? frameIdx % this._frameCount : -1;
        }

        public void fastForward(long timeDelta) {
            this._startStamp += timeDelta;
        }
    }
}

