/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sound;

import com.google.common.collect.Maps;
import com.samskivert.io.StreamUtil;
import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.util.LRUHashMap;
import com.samskivert.util.Queue;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.RunQueue;
import com.samskivert.util.StringUtil;
import com.threerings.media.Log;
import com.threerings.media.MediaPrefs;
import com.threerings.media.sound.SoundLoader;
import com.threerings.media.sound.SoundPlayer;
import com.threerings.resource.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class JavaSoundPlayer
extends SoundPlayer {
    public static final int DEFAULT_CACHE_SIZE = 0x400000;
    protected SoundLoader _loader;
    protected RunQueue _callbackQueue = RunQueue.AWT;
    protected Queue<SoundKey> _queue = new Queue();
    protected int _spoolerCount;
    protected int _freeSpoolers;
    protected boolean _soundSeemsToWork = false;
    protected LRUHashMap<SoundKey, byte[][]> _clipCache;
    protected HashMap<SoundKey, byte[][]> _lockedClips = Maps.newHashMap();
    protected static final byte PLAY = 0;
    protected static final byte LOCK = 1;
    protected static final byte UNLOCK = 2;
    protected static final byte DIE = 3;
    protected static final byte LOOP = 4;
    protected static RuntimeAdjust.FileAdjust _testDir = new RuntimeAdjust.FileAdjust("Test sound directory", "narya.media.sound.test_dir", MediaPrefs.config, true, "");
    protected static RuntimeAdjust.BooleanAdjust _verbose = new RuntimeAdjust.BooleanAdjust("Verbose sound event logging", "narya.media.sound.verbose", MediaPrefs.config, false);
    protected static final int MAX_QUEUE_SIZE = 25;
    protected static final long MAX_SOUND_DELAY = 400L;
    protected static final int LINEBUF_SIZE = 16384;
    protected static final long MAX_WAIT_TIME = 30000L;
    protected static final int MAX_SPOOLERS = 12;

    public JavaSoundPlayer(ResourceManager rmgr) {
        this(rmgr, null, null);
    }

    public JavaSoundPlayer(ResourceManager rmgr, String defaultClipBundle, String defaultClipPath) {
        this(rmgr, defaultClipBundle, defaultClipPath, 0x400000);
    }

    public JavaSoundPlayer(ResourceManager rmgr, String defaultClipBundle, String defaultClipPath, int cacheSize) {
        this(new SoundLoader(rmgr, defaultClipBundle, defaultClipPath), cacheSize);
    }

    public JavaSoundPlayer(SoundLoader loader, int cacheSize) {
        this._loader = loader;
        this._clipCache = new LRUHashMap(cacheSize, (LRUHashMap.ItemSizer)new LRUHashMap.ItemSizer<byte[][]>(){

            public int computeSize(byte[][] value) {
                int total = 0;
                for (byte[] bs : value) {
                    total += bs.length;
                }
                return total;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Queue<SoundKey> queue = this._queue;
        synchronized (queue) {
            this._queue.clear();
            if (this._spoolerCount > 0) {
                this._queue.append((Object)new SoundKey(3));
            }
        }
        queue = this._clipCache;
        synchronized (queue) {
            this._lockedClips.clear();
            this._loader.shutdown();
        }
    }

    public void setSoundQueue(RunQueue queue) {
        this._callbackQueue = queue;
    }

    public RunQueue getSoundQueue() {
        return this._callbackQueue;
    }

    public void lock(String pkgPath, String ... keys) {
        for (int ii = 0; ii < keys.length; ++ii) {
            this.enqueue(new SoundKey(1, pkgPath, keys[ii]), ii == 0);
        }
    }

    public void unlock(String pkgPath, String ... keys) {
        for (int ii = 0; ii < keys.length; ++ii) {
            this.enqueue(new SoundKey(2, pkgPath, keys[ii]), ii == 0);
        }
    }

    protected void play(String pkgPath, String key, float pan) {
        this.addToPlayQueue(new SoundKey(0, pkgPath, key, 0, this._clipVol, pan));
    }

    protected SoundPlayer.Frob loop(String pkgPath, String key, float pan) {
        return this.loop(pkgPath, key, pan, (byte)4);
    }

    protected SoundPlayer.Frob loop(String pkgPath, String key, float pan, byte cmd) {
        SoundKey skey = new SoundKey(cmd, pkgPath, key, 0, this._clipVol, pan);
        this.addToPlayQueue(skey);
        return skey;
    }

    protected void addToPlayQueue(SoundKey skey) {
        boolean queued = this.enqueue(skey, true);
        if (queued) {
            if (_verbose.getValue()) {
                Log.log.info((Object)("Sound request [key=" + skey.key + "]."), new Object[0]);
            }
        } else {
            Log.log.warning((Object)("SoundManager not playing sound because too many sounds in queue [key=" + skey + "]."), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean enqueue(SoundKey key, boolean okToStartNew) {
        boolean queued;
        boolean add;
        Queue<SoundKey> queue = this._queue;
        synchronized (queue) {
            if (key.cmd == 0 && this._queue.size() > 25) {
                add = false;
                queued = false;
            } else {
                this._queue.appendLoud((Object)key);
                queued = true;
                boolean bl = add = okToStartNew && this._freeSpoolers == 0 && this._spoolerCount < 12;
                if (add) {
                    ++this._spoolerCount;
                }
            }
        }
        if (add) {
            Thread spooler = new Thread("narya SoundManager line spooler"){

                public void run() {
                    JavaSoundPlayer.this.spoolerRun();
                }
            };
            spooler.setDaemon(true);
            spooler.start();
        }
        return queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void spoolerRun() {
        while (true) {
            try {
                while (true) {
                    SoundKey key;
                    Queue<SoundKey> queue = this._queue;
                    synchronized (queue) {
                        ++this._freeSpoolers;
                        key = (SoundKey)this._queue.get(30000L);
                        --this._freeSpoolers;
                        if (key == null || key.cmd == 3) {
                            --this._spoolerCount;
                            if (key != null && this._spoolerCount > 0) {
                                this._queue.appendLoud((Object)key);
                            }
                            return;
                        }
                    }
                    this.processKey(key);
                }
            }
            catch (Exception e) {
                Log.log.warning((Object)e, new Object[0]);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processKey(SoundKey key) throws Exception {
        switch (key.cmd) {
            case 0: 
            case 4: {
                this.playSound(key);
                break;
            }
            case 1: {
                if (this.isTesting()) break;
                LRUHashMap<SoundKey, byte[][]> lRUHashMap = this._clipCache;
                synchronized (lRUHashMap) {
                    try {
                        this.getClipData(key);
                        this._lockedClips.put(key, (byte[][])this._clipCache.get((Object)key));
                    }
                    catch (Exception e) {
                        if (!_verbose.getValue()) break;
                        throw e;
                    }
                    break;
                }
            }
            case 2: {
                LRUHashMap<SoundKey, byte[][]> lRUHashMap = this._clipCache;
                synchronized (lRUHashMap) {
                    this._lockedClips.remove(key);
                    break;
                }
            }
        }
    }

    public static AudioInputStream setupAudioStream(byte[] data) throws UnsupportedAudioFileException, IOException {
        return JavaSoundPlayer.setupAudioStream(new ByteArrayInputStream(data));
    }

    public static AudioInputStream setupAudioStream(InputStream in) throws UnsupportedAudioFileException, IOException {
        AudioInputStream stream = AudioSystem.getAudioInputStream(in);
        AudioFormat format = stream.getFormat();
        if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            stream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), 16, format.getChannels(), format.getChannels() * 2, format.getSampleRate(), false), stream);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playSound(SoundKey key) {
        if (!key.running) {
            return;
        }
        key.thread = Thread.currentThread();
        Line line = null;
        try {
            int sampleSize;
            byte[] data = this.getClipData(key);
            if (data == null) {
                return;
            }
            if (key.isExpired()) {
                if (_verbose.getValue()) {
                    Log.log.info((Object)("Sound expired [key=" + key.key + "]."), new Object[0]);
                }
                return;
            }
            AudioInputStream stream = JavaSoundPlayer.setupAudioStream(data);
            if (key.isLoop() && stream.markSupported()) {
                stream.mark(data.length);
            }
            AudioFormat format = stream.getFormat();
            line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, format));
            line.open(format, 16384);
            float setVolume = 1.0f;
            float setPan = 0.0f;
            line.start();
            this._soundSeemsToWork = true;
            long startTime = System.currentTimeMillis();
            byte[] buffer = new byte[16384];
            int totalRead = 0;
            do {
                int count = 0;
                while (key.running && count != -1) {
                    float pan;
                    float vol = key.volume;
                    if (vol != setVolume) {
                        JavaSoundPlayer.adjustVolume(line, vol);
                        setVolume = vol;
                    }
                    if ((pan = key.pan) != setPan) {
                        JavaSoundPlayer.adjustPan(line, pan);
                        setPan = pan;
                    }
                    try {
                        count = stream.read(buffer, 0, buffer.length);
                        totalRead += count;
                    }
                    catch (IOException e) {
                        Log.log.warning((Object)"Error reading clip data!", new Object[]{e});
                        if (line != null) {
                            line.close();
                        }
                        key.thread = null;
                        return;
                    }
                    if (count < 0) continue;
                    line.write(buffer, 0, count);
                }
                if (!key.isLoop()) continue;
                if (stream.markSupported()) {
                    stream.reset();
                    continue;
                }
                stream = JavaSoundPlayer.setupAudioStream(data);
            } while (key.isLoop() && key.running);
            float sampleRate = format.getSampleRate();
            if (sampleRate == -1.0f) {
                sampleRate = 11025.0f;
            }
            if ((sampleSize = format.getSampleSizeInBits()) == -1) {
                sampleSize = 16;
            }
            int drainTime = (int)Math.ceil((float)((long)(totalRead * 8) * 1000L) / (sampleRate * (float)sampleSize));
            drainTime = (int)((long)drainTime - (System.currentTimeMillis() - startTime));
            drainTime = Math.max(0, drainTime);
            drainTime += 500;
            try {
                Thread.sleep(drainTime);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Error loading sound file [key=" + key + ", e=" + ioe + "]."), new Object[0]);
        }
        catch (UnsupportedAudioFileException uafe) {
            Log.log.warning((Object)("Unsupported sound format [key=" + key + ", e=" + uafe + "]."), new Object[0]);
        }
        catch (LineUnavailableException lue) {
            String err = "Line not available to play sound [key=" + key.key + ", e=" + lue + "].";
            if (this._soundSeemsToWork) {
                Log.log.warning((Object)err, new Object[0]);
            } else {
                Log.log.debug((Object)err, new Object[0]);
            }
        }
        finally {
            if (line != null) {
                line.close();
            }
            key.thread = null;
        }
    }

    protected boolean isTesting() {
        return !StringUtil.isBlank((String)_testDir.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getClipData(SoundKey key) throws IOException, UnsupportedAudioFileException {
        Object data;
        LRUHashMap<SoundKey, byte[][]> lRUHashMap = this._clipCache;
        synchronized (lRUHashMap) {
            if (this.isTesting()) {
                this._clipCache.clear();
            }
            if ((data = (byte[][])this._clipCache.get((Object)key)) == null) {
                data = this._lockedClips.get(key);
            }
            if (data == null) {
                InputStream stream = this.getTestClip(key);
                if (stream != null) {
                    data = new byte[1][];
                    data[0] = StreamUtil.toByteArray((InputStream)stream);
                } else {
                    data = this._loader.load(key.pkgPath, key.key);
                }
                this._clipCache.put((Object)key, data);
            }
        }
        return ((byte[][])data).length > 0 ? data[RandomUtil.getInt((int)((byte[][])data).length)] : null;
    }

    protected InputStream getTestClip(SoundKey key) {
        String testDirectory = _testDir.getValue();
        if (StringUtil.isBlank((String)testDirectory)) {
            return null;
        }
        File f = new File(testDirectory);
        final String namePrefix = key.key;
        File[] list = f.listFiles(new FilenameFilter(){

            public boolean accept(File f, String name) {
                if (name.startsWith(namePrefix)) {
                    String extra;
                    String backhalf = name.substring(namePrefix.length());
                    int dot = backhalf.indexOf(46);
                    if (dot == -1) {
                        dot = backhalf.length();
                    }
                    if ("".equals(extra = backhalf.substring(0, dot))) {
                        return true;
                    }
                    try {
                        Integer.parseInt(extra);
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                return false;
            }
        });
        if (list == null) {
            return null;
        }
        if (list.length > 0) {
            File pick = list[RandomUtil.getInt((int)list.length)];
            try {
                return new FileInputStream(pick);
            }
            catch (Exception e) {
                Log.log.warning((Object)("Error reading test sound [e=" + e + ", file=" + pick + "]."), new Object[0]);
            }
        }
        return null;
    }

    protected static void adjustVolume(Line line, float vol) {
        FloatControl control = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
        float gain = vol == 0.0f ? control.getMinimum() : (float)(Math.log(vol) / Math.log(10.0) * 20.0);
        control.setValue(gain);
    }

    protected static void adjustPan(Line line, float pan) {
        try {
            FloatControl control = (FloatControl)line.getControl(FloatControl.Type.PAN);
            control.setValue(pan);
        }
        catch (Exception e) {
            Log.log.debug((Object)("Cannot set pan on line: " + e), new Object[0]);
        }
    }

    protected static class SoundKey
    implements SoundPlayer.Frob {
        public byte cmd;
        public String pkgPath;
        public String key;
        public long stamp;
        public volatile boolean running = true;
        public volatile float volume;
        public volatile float pan;
        public Thread thread;

        public SoundKey(byte cmd) {
            this.cmd = cmd;
        }

        public SoundKey(byte cmd, String pkgPath, String key) {
            this(cmd);
            this.pkgPath = pkgPath;
            this.key = key;
        }

        public SoundKey(byte cmd, String pkgPath, String key, int delay, float volume, float pan) {
            this(cmd, pkgPath, key);
            this.stamp = System.currentTimeMillis() + (long)delay;
            this.setVolume(volume);
            this.setPan(pan);
        }

        public void stop() {
            this.running = false;
            Thread t = this.thread;
            if (t != null) {
                t.interrupt();
            }
        }

        public void setVolume(float vol) {
            this.volume = Math.max(0.0f, Math.min(1.0f, vol));
        }

        public float getVolume() {
            return this.volume;
        }

        public void setPan(float newPan) {
            this.pan = Math.max(-1.0f, Math.min(1.0f, newPan));
        }

        public float getPan() {
            return this.pan;
        }

        public boolean isExpired() {
            return this.stamp + 400L < System.currentTimeMillis();
        }

        protected boolean isLoop() {
            return this.cmd == 4;
        }

        public String toString() {
            return "SoundKey{cmd=" + this.cmd + ", pkgPath=" + this.pkgPath + ", key=" + this.key + "}";
        }

        public int hashCode() {
            return this.pkgPath.hashCode() ^ this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SoundKey) {
                SoundKey that = (SoundKey)o;
                return this.pkgPath.equals(that.pkgPath) && this.key.equals(that.key);
            }
            return false;
        }
    }
}

