/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.threerings.media.image.ImageUtil;
import com.threerings.media.image.Mirage;
import com.threerings.media.image.NinePatch;
import com.threerings.media.image.TransformedMirage;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class NinePatchMirage
implements Mirage {
    protected final NinePatch _ninePatch;
    protected final int _width;
    protected final int _height;

    public NinePatchMirage(BufferedImage img, int width, int height) {
        this(new NinePatch(img), width, height);
    }

    public NinePatchMirage(NinePatch ninePatch, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Illegal dimensions");
        }
        this._ninePatch = ninePatch;
        this._width = width;
        this._height = height;
    }

    public static Mirage newNinePatchContaining(NinePatch ninePatch, Rectangle content) {
        Rectangle bounds = ninePatch.getBoundsSurrounding(content);
        NinePatchMirage mirage = new NinePatchMirage(ninePatch, bounds.width, bounds.height);
        return new TransformedMirage(mirage, AffineTransform.getTranslateInstance(bounds.x, bounds.y), false);
    }

    public long getEstimatedMemoryUsage() {
        return ImageUtil.getEstimatedMemoryUsage(this._ninePatch._img.getRaster());
    }

    public BufferedImage getSnapshot() {
        BufferedImage img = new BufferedImage(this._width, this._height, 2);
        this._ninePatch.paint(img.createGraphics(), new Rectangle(0, 0, this._width, this._height));
        return img;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public boolean hitTest(int x, int y) {
        return ImageUtil.hitTest(this.getSnapshot(), x, y);
    }

    public void paint(Graphics2D gfx, int x, int y) {
        this._ninePatch.paint(gfx, new Rectangle(x, y, this._width, this._height));
    }
}

