/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.samskivert.swing.Label;
import com.samskivert.util.Logger;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.Mirage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtil {
    protected static GraphicsConfiguration _gc;
    protected static final int TRANS_MASK = -16777216;
    protected static final int RGB_MASK = 0xFFFFFF;

    public static BufferedImage createCompatibleImage(BufferedImage source, int width, int height) {
        WritableRaster raster = source.getRaster().createCompatibleWritableRaster(width, height);
        return new BufferedImage(source.getColorModel(), raster, false, null);
    }

    public static BufferedImage createErrorImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 13);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(Color.red);
        Label l = new Label("Error");
        l.layout(g);
        Dimension d = l.getSize();
        for (int yy = 0; yy < height; yy += d.height) {
            for (int xx = 0; xx < width; xx += d.width + 5) {
                l.render(g, (float)xx, (float)yy);
            }
        }
        g.dispose();
        return img;
    }

    public static BufferedImage recolorImage(BufferedImage image, Color rootColor, float[] dists, float[] offsets) {
        return ImageUtil.recolorImage(image, new Colorization[]{new Colorization(-1, rootColor, dists, offsets)});
    }

    public static BufferedImage recolorImage(BufferedImage image, Colorization cz) {
        return ImageUtil.recolorImage(image, new Colorization[]{cz});
    }

    public static BufferedImage recolorImage(BufferedImage image, Colorization[] zations) {
        ColorModel cm = image.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            throw new RuntimeException(Logger.format((Object)"Unable to recolor images with non-index color model", (Object[])new Object[]{"cm", cm.getClass()}));
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int size = icm.getMapSize();
        int zcount = zations.length;
        int[] rgbs = new int[size];
        icm.getRGBs(rgbs);
        float[] hsv = new float[3];
        int[] fhsv = new int[3];
        block0: for (int ii = 0; ii < size; ++ii) {
            int value = rgbs[ii];
            if ((value & 0xFF000000) == 0) continue;
            int red = value >> 16 & 0xFF;
            int green = value >> 8 & 0xFF;
            int blue = value >> 0 & 0xFF;
            Color.RGBtoHSB(red, green, blue, hsv);
            Colorization.toFixedHSV(hsv, fhsv);
            for (int z = 0; z < zcount; ++z) {
                Colorization cz = zations[z];
                if (cz == null || !cz.matches(hsv, fhsv)) continue;
                rgbs[ii] = cz.recolorColor(hsv);
                continue block0;
            }
        }
        IndexColorModel nicm = new IndexColorModel(icm.getPixelSize(), size, rgbs, 0, icm.hasAlpha(), icm.getTransparentPixel(), icm.getTransferType());
        return new BufferedImage(nicm, image.getRaster(), false, null);
    }

    public static void tileImage(Graphics2D gfx, Mirage image, int x, int y, int width, int height) {
        int iwidth = image.getWidth();
        int iheight = image.getHeight();
        int xnum = width / iwidth;
        int xplus = width % iwidth;
        int ynum = height / iheight;
        int yplus = height % iheight;
        Shape oclip = gfx.getClip();
        for (int ii = 0; ii < ynum; ++ii) {
            int xx = x;
            for (int jj = 0; jj < xnum; ++jj) {
                image.paint(gfx, xx, y);
                xx += iwidth;
            }
            if (xplus > 0) {
                gfx.clipRect(xx, y, xplus, iheight);
                image.paint(gfx, xx, y);
                gfx.setClip(oclip);
            }
            y += iheight;
        }
        if (yplus > 0) {
            int xx = x;
            for (int jj = 0; jj < xnum; ++jj) {
                gfx.clipRect(xx, y, iwidth, yplus);
                image.paint(gfx, xx, y);
                gfx.setClip(oclip);
                xx += iwidth;
            }
            if (xplus > 0) {
                gfx.clipRect(xx, y, xplus, yplus);
                image.paint(gfx, xx, y);
                gfx.setClip(oclip);
            }
        }
    }

    public static void tileImageAcross(Graphics2D gfx, Mirage image, int x, int y, int width) {
        ImageUtil.tileImage(gfx, image, x, y, width, image.getHeight());
    }

    public static void tileImageDown(Graphics2D gfx, Mirage image, int x, int y, int height) {
        ImageUtil.tileImage(gfx, image, x, y, image.getWidth(), height);
    }

    public static BufferedImage createTracedImage(ImageCreator isrc, BufferedImage src, Color tcolor, int thickness) {
        return ImageUtil.createTracedImage(isrc, src, tcolor, thickness, 1.0f, 1.0f);
    }

    public static BufferedImage createTracedImage(ImageCreator isrc, BufferedImage src, Color tcolor, int thickness, float startAlpha, float endAlpha) {
        int wid = src.getWidth();
        int hei = src.getHeight();
        BufferedImage dest = isrc.createImage(wid, hei, 3);
        return ImageUtil.createTracedImage(src, dest, tcolor, thickness, startAlpha, endAlpha);
    }

    public static BufferedImage createTracedImage(BufferedImage src, BufferedImage dest, Color tcolor, int thickness, float startAlpha, float endAlpha) {
        int wid = src.getWidth();
        int hei = src.getHeight();
        int spixel = tcolor.getRGB() & 0xFFFFFF;
        int salpha = (int)(startAlpha * 255.0f);
        int tpixel = spixel | salpha << 24;
        boolean[] traced = new boolean[wid * hei];
        int stepAlpha = thickness <= 1 ? 0 : (int)((startAlpha - endAlpha) * 255.0f / (float)(thickness - 1));
        for (int tt = 0; tt < thickness; ++tt) {
            if (tt > 0) {
                Arrays.fill(traced, false);
                src = dest;
                tpixel = spixel | (salpha -= Math.max(0, stepAlpha)) << 24;
            }
            for (int yy = 0; yy < hei; ++yy) {
                for (int xx = 0; xx < wid; ++xx) {
                    int argb = src.getRGB(xx, yy);
                    if ((argb & 0xFF000000) != 0) {
                        dest.setRGB(xx, yy, argb);
                        continue;
                    }
                    if (!ImageUtil.bordersNonTransparentPixel(src, wid, hei, traced, xx, yy)) continue;
                    dest.setRGB(xx, yy, tpixel);
                    traced[yy * wid + xx] = true;
                }
            }
        }
        return dest;
    }

    protected static boolean bordersNonTransparentPixel(BufferedImage data, int wid, int hei, boolean[] traced, int x, int y) {
        int rxx;
        if (y > 0) {
            for (rxx = x - 1; rxx <= x + 1; ++rxx) {
                if (rxx < 0 || rxx >= wid || traced[(y - 1) * wid + rxx] || (data.getRGB(rxx, y - 1) & 0xFF000000) == 0) continue;
                return true;
            }
        }
        if (x > 0 && !traced[y * wid + (x - 1)] && (data.getRGB(x - 1, y) & 0xFF000000) != 0) {
            return true;
        }
        if (x < wid - 1 && !traced[y * wid + (x + 1)] && (data.getRGB(x + 1, y) & 0xFF000000) != 0) {
            return true;
        }
        if (y < hei - 1) {
            for (rxx = x - 1; rxx <= x + 1; ++rxx) {
                if (rxx < 0 || rxx >= wid || traced[(y + 1) * wid + rxx] || (data.getRGB(rxx, y + 1) & 0xFF000000) == 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage composeMaskedImage(ImageCreator isrc, BufferedImage mask, BufferedImage base) {
        int wid = base.getWidth();
        int hei = base.getHeight();
        Raster maskdata = mask.getData();
        Raster basedata = base.getData();
        if (maskdata.getNumBands() == 4 && basedata.getNumBands() >= 3) {
            WritableRaster target = basedata.createCompatibleWritableRaster(wid, hei);
            int[] adata = maskdata.getSamples(0, 0, wid, hei, 3, (int[])null);
            target.setSamples(0, 0, wid, hei, 3, adata);
            for (int ii = 0; ii < 3; ++ii) {
                int[] cdata = basedata.getSamples(0, 0, wid, hei, ii, (int[])null);
                target.setSamples(0, 0, wid, hei, ii, cdata);
            }
            return new BufferedImage(mask.getColorModel(), target, true, null);
        }
        BufferedImage target = isrc.createImage(wid, hei, 3);
        Graphics2D g2 = target.createGraphics();
        try {
            g2.drawImage((Image)mask, 0, 0, null);
            g2.setComposite(AlphaComposite.SrcIn);
            g2.drawImage((Image)base, 0, 0, null);
        }
        finally {
            g2.dispose();
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage composeMaskedImage(ImageCreator isrc, Shape mask, BufferedImage base) {
        int wid = base.getWidth();
        int hei = base.getHeight();
        BufferedImage target = isrc.createImage(wid, hei, 3);
        Graphics2D g2 = target.createGraphics();
        try {
            g2.setColor(Color.BLACK);
            g2.fill(mask);
            g2.setComposite(AlphaComposite.SrcIn);
            g2.drawImage((Image)base, 0, 0, null);
        }
        finally {
            g2.dispose();
        }
        return target;
    }

    public static boolean hitTest(BufferedImage image, int x, int y) {
        int argb = image.getRGB(x, y);
        return argb >> 24 != 0;
    }

    public static void computeTrimmedBounds(BufferedImage image, Rectangle tbounds) {
        int width = image.getWidth();
        int height = image.getHeight();
        int firstrow = -1;
        int lastrow = -1;
        int minx = width;
        int maxx = 0;
        for (int yy = 0; yy < height; ++yy) {
            int firstidx = -1;
            int lastidx = -1;
            for (int xx = 0; xx < width; ++xx) {
                int argb = image.getRGB(xx, yy);
                if (argb >> 24 == 0) continue;
                if (firstidx == -1) {
                    firstidx = xx;
                }
                lastidx = xx;
            }
            if (firstidx == -1) continue;
            minx = Math.min(firstidx, minx);
            maxx = Math.max(lastidx, maxx);
            if (firstrow == -1) {
                firstrow = yy;
            }
            lastrow = yy;
        }
        if (firstrow != -1) {
            tbounds.x = minx;
            tbounds.y = firstrow;
            tbounds.width = maxx - minx + 1;
            tbounds.height = lastrow - firstrow + 1;
        } else {
            tbounds.x = 0;
            tbounds.y = 0;
            tbounds.width = 1;
            tbounds.height = 1;
        }
    }

    public static long getEstimatedMemoryUsage(BufferedImage image) {
        if (image != null) {
            return ImageUtil.getEstimatedMemoryUsage(image.getRaster());
        }
        return 0L;
    }

    public static long getEstimatedMemoryUsage(Raster raster) {
        DataBuffer db = raster.getDataBuffer();
        int bpe = (int)Math.ceil((float)DataBuffer.getDataTypeSize(db.getDataType()) / 8.0f);
        return bpe * db.getSize();
    }

    public static long getEstimatedMemoryUsage(Iterator<BufferedImage> iter) {
        long size = 0L;
        while (iter.hasNext()) {
            BufferedImage image = iter.next();
            size += ImageUtil.getEstimatedMemoryUsage(image);
        }
        return size;
    }

    protected static GraphicsConfiguration getDefGC() {
        if (_gc == null) {
            try {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = env.getDefaultScreenDevice();
                _gc = gd.getDefaultConfiguration();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        return _gc;
    }

    public static interface ImageCreator {
        public BufferedImage createImage(int var1, int var2, int var3);
    }
}

