/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.effects;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;

public class FadeEffect {
    protected Composite _comp;
    protected Composite _ocomp;
    protected float _alpha;
    protected float _target;
    protected float _step;
    protected float _startAlpha;
    protected long _initStamp;
    protected boolean _finished;

    public FadeEffect(float alpha, float step, float target) {
        if (step == 0.0f || alpha > target && step > 0.0f || alpha < target && step < 0.0f) {
            throw new IllegalArgumentException("Step specified is illegal: Fade would never finish (start=" + alpha + ", step=" + step + ", target=" + target + ")");
        }
        this._startAlpha = alpha;
        this._step = step;
        this._target = target;
        this._alpha = Math.max(0.0f, Math.min(1.0f, this._startAlpha));
        this._comp = AlphaComposite.getInstance(3, this._alpha);
    }

    public void init(long tickStamp) {
        this._finished = false;
        this._initStamp = tickStamp;
    }

    public boolean finished() {
        return this._finished;
    }

    public float getAlpha() {
        return this._alpha;
    }

    public boolean tick(long tickStamp) {
        long msecs = tickStamp - this._initStamp;
        float alpha = this._startAlpha + (float)msecs * this._step;
        boolean bl = this._startAlpha < this._target ? alpha >= this._target : (this._finished = alpha <= this._target);
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        if (this._alpha != alpha) {
            this._alpha = alpha;
            this._comp = AlphaComposite.getInstance(3, this._alpha);
            return true;
        }
        return this._finished;
    }

    public void beforePaint(Graphics2D gfx) {
        this._ocomp = gfx.getComposite();
        gfx.setComposite(this._comp);
    }

    public void afterPaint(Graphics2D gfx) {
        gfx.setComposite(this._ocomp);
    }
}

