/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.threerings.media.VirtualMediaPanel;
import com.threerings.media.util.MathUtil;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VirtualRangeModel
implements ChangeListener {
    protected VirtualMediaPanel _panel;
    protected BoundedRangeModel _hrange = new DefaultBoundedRangeModel();
    protected BoundedRangeModel _vrange = new DefaultBoundedRangeModel();

    public VirtualRangeModel(VirtualMediaPanel panel) {
        this._panel = panel;
        this._hrange.addChangeListener(this);
        this._vrange.addChangeListener(this);
    }

    public void setScrollableArea(int x, int y, int width, int height) {
        int value;
        Rectangle vb = this._panel.getViewBounds();
        int hmax = x + width;
        int vmax = y + height;
        if (width > vb.width) {
            value = MathUtil.bound(x, this._hrange.getValue(), hmax - vb.width);
            this._hrange.setRangeProperties(value, vb.width, x, hmax, false);
        } else {
            int newx = x - (vb.width - width) / 2;
            this._hrange.setRangeProperties(newx, 0, newx, newx, false);
        }
        if (height > vb.height) {
            value = MathUtil.bound(y, this._vrange.getValue(), vmax - vb.height);
            this._vrange.setRangeProperties(value, vb.height, y, vmax, false);
        } else {
            int newy = y - (vb.height - height) / 2;
            this._vrange.setRangeProperties(newy, 0, newy, newy, false);
        }
    }

    public BoundedRangeModel getHorizModel() {
        return this._hrange;
    }

    public BoundedRangeModel getVertModel() {
        return this._vrange;
    }

    public void stateChanged(ChangeEvent e) {
        this._panel.setViewLocation(this._hrange.getValue(), this._vrange.getValue());
    }
}

