/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.google.common.collect.Lists;
import com.samskivert.util.RunAnywhere;
import com.threerings.media.FrameManager;
import com.threerings.media.Log;
import com.threerings.media.MediaPanel;
import com.threerings.media.ViewTracker;
import com.threerings.media.image.ImageUtil;
import com.threerings.media.image.Mirage;
import com.threerings.media.util.MathUtil;
import com.threerings.media.util.Pathable;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class VirtualMediaPanel
extends MediaPanel {
    public static final byte CENTER_ON_PATHABLE = 0;
    public static final byte ENCLOSE_PATHABLE = 1;
    public static final byte TRACK_PATHABLE = 2;
    protected Rectangle _vbounds = new Rectangle();
    protected int _nx;
    protected int _ny;
    protected int _dx;
    protected int _dy;
    protected Mirage _background;
    protected byte _fmode = (byte)-1;
    protected Pathable _fpath;
    protected Rectangle _abounds = new Rectangle();
    protected ArrayList<ViewTracker> _trackers = Lists.newArrayList();

    public VirtualMediaPanel(FrameManager framemgr) {
        super(framemgr);
    }

    public void setBackground(Mirage background) {
        this._background = background;
    }

    public void setViewLocation(int x, int y) {
        this._nx = x;
        this._ny = y;
    }

    public Rectangle getViewBounds() {
        return this._vbounds;
    }

    public void addViewTracker(ViewTracker tracker) {
        this._trackers.add(tracker);
    }

    public void removeViewTracker(ViewTracker tracker) {
        this._trackers.remove(tracker);
    }

    public void setFollowsPathable(Pathable pable, byte followMode) {
        this._fmode = followMode;
        this._fpath = pable;
        this.trackPathable();
    }

    public void clearPathable() {
        this._fpath = null;
        this._fmode = (byte)-1;
    }

    protected void processMouseEvent(MouseEvent event) {
        event.translatePoint(this._vbounds.x, this._vbounds.y);
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        event.translatePoint(this._vbounds.x, this._vbounds.y);
        super.processMouseMotionEvent(event);
    }

    protected void processMouseWheelEvent(MouseWheelEvent event) {
        event.translatePoint(this._vbounds.x, this._vbounds.y);
        super.processMouseWheelEvent(event);
    }

    protected void dirtyScreenRect(Rectangle rect) {
        rect.translate(this._vbounds.x, this._vbounds.y);
        this._metamgr.getRegionManager().addDirtyRegion(rect);
    }

    public void doLayout() {
        super.doLayout();
        this.findRootBounds();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this._vbounds.width = this.getWidth();
        this._vbounds.height = this.getHeight();
        this.findRootBounds();
    }

    protected void addObscurerDirtyRegion(Rectangle region) {
        super.addObscurerDirtyRegion(new Rectangle(region.x - this._dx, region.y - this._dy, region.width, region.height));
    }

    protected void findRootBounds() {
        this._abounds.setLocation(0, 0);
        FrameManager.getRoot(this, this._abounds);
    }

    protected void didTick(long tickStamp) {
        super.didTick(tickStamp);
        this.adjustBoundsCenter();
    }

    protected void adjustBoundsCenter() {
        int width = this.getWidth();
        int height = this.getHeight();
        this.trackPathable();
        if (this._nx != this._vbounds.x || this._ny != this._vbounds.y) {
            int dx = this._nx - this._vbounds.x;
            int dy = this._ny - this._vbounds.y;
            this._dx = dx;
            this._dy = dy;
            int sy = this._ny;
            int shei = height;
            if (dy > 0) {
                shei = Math.max(shei - dy, 0);
                this._metamgr.getRegionManager().invalidateRegion(this._nx, this._ny + height - dy, width, dy);
            } else if (dy < 0) {
                sy -= dy;
                this._metamgr.getRegionManager().invalidateRegion(this._nx, this._ny, width, -dy);
            }
            if (dx > 0) {
                this._metamgr.getRegionManager().invalidateRegion(this._nx + width - dx, sy, dx, shei);
            } else if (dx < 0) {
                this._metamgr.getRegionManager().invalidateRegion(this._nx, sy, -dx, shei);
            }
            this._vbounds.x = this._nx;
            this._vbounds.y = this._ny;
            this.addObscurerDirtyRegions(false);
            this.viewLocationDidChange(dx, dy);
        }
    }

    protected void viewLocationDidChange(int dx, int dy) {
        int ll = this._trackers.size();
        for (int ii = 0; ii < ll; ++ii) {
            this._trackers.get(ii).viewLocationDidChange(dx, dy);
        }
        this._metamgr.viewLocationDidChange(dx, dy);
    }

    protected void trackPathable() {
        if (this._fpath == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int nx = this._vbounds.x;
        int ny = this._vbounds.y;
        switch (this._fmode) {
            case 2: {
                nx = this._fpath.getX();
                ny = this._fpath.getY();
                break;
            }
            case 0: {
                nx = this._fpath.getX() - width / 2;
                ny = this._fpath.getY() - height / 2;
                break;
            }
            case 1: {
                Rectangle bounds = this._fpath.getBounds();
                if (nx > bounds.x) {
                    nx = bounds.x;
                } else if (nx + width < bounds.x + bounds.width) {
                    nx = bounds.x + bounds.width - width;
                }
                if (ny > bounds.y) {
                    ny = bounds.y;
                    break;
                }
                if (ny + height >= bounds.y + bounds.height) break;
                ny = bounds.y + bounds.height - height;
                break;
            }
            default: {
                Log.log.warning((Object)"Eh? Set to invalid pathable mode", new Object[]{"mode", this._fmode});
            }
        }
        this.setViewLocation(nx, ny);
    }

    protected void paint(Graphics2D gfx, Rectangle[] dirty) {
        if (this._dx != 0 || this._dy != 0) {
            int width = this.getWidth();
            int height = this.getHeight();
            int cx = this._dx > 0 ? this._dx : 0;
            int cy = this._dy > 0 ? this._dy : 0;
            gfx.setClip(0, 0, width, height);
            if (RunAnywhere.isWindows()) {
                gfx.translate(-this._abounds.x, -this._abounds.y);
                gfx.copyArea(this._abounds.x + cx, this._abounds.y + cy, width - Math.abs(this._dx), height - Math.abs(this._dy), -this._dx, -this._dy);
                gfx.translate(this._abounds.x, this._abounds.y);
            } else if (RunAnywhere.isMacOS()) {
                try {
                    gfx.copyArea(cx, cy, width - Math.abs(this._dx), height - Math.abs(this._dy), -this._dx, -this._dy);
                }
                catch (Exception e) {
                    dirty = new Rectangle[]{new Rectangle(this._vbounds)};
                }
            } else {
                gfx.copyArea(cx, cy, width - Math.abs(this._dx), height - Math.abs(this._dy), -this._dx, -this._dy);
            }
            this._dx = 0;
            this._dy = 0;
        }
        gfx.translate(-this._vbounds.x, -this._vbounds.y);
        super.paint(gfx, dirty);
        gfx.translate(this._vbounds.x, this._vbounds.y);
    }

    protected void constrainToBounds(Rectangle dirty) {
        SwingUtilities.computeIntersection(this._vbounds.x, this._vbounds.y, this.getWidth(), this.getHeight(), dirty);
    }

    protected void paintBehind(Graphics2D gfx, Rectangle dirtyRect) {
        if (this._background != null) {
            int iw = this._background.getWidth();
            int ih = this._background.getHeight();
            int lowx = iw * MathUtil.floorDiv(dirtyRect.x, iw);
            int lowy = ih * MathUtil.floorDiv(dirtyRect.y, ih);
            ImageUtil.tileImage(gfx, this._background, lowx, lowy, dirtyRect.width + (dirtyRect.x - lowx), dirtyRect.height + (dirtyRect.y - lowy));
        }
    }
}

