/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.threerings.media.FrameManager;
import com.threerings.media.TimerView;
import com.threerings.media.image.Mirage;
import com.threerings.media.util.MultiFrameImage;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public class HourglassView
extends TimerView {
    protected Rectangle _topRect;
    protected Rectangle _botRect;
    protected Point _topOff;
    protected Point _botOff;
    protected Mirage _hourglass;
    protected Mirage _sandTop;
    protected Mirage _sandBottom;
    protected MultiFrameImage _sandTrickle;
    protected long _sandStamp;
    protected int _sandFrame;
    protected int _sandY;
    protected static final long SAND_RATE = 80L;

    public HourglassView(FrameManager fmgr, JComponent host, int x, int y, Mirage glassImage, Mirage topImage, Rectangle topRect, Mirage botImage, Rectangle botRect, MultiFrameImage sandTrickle) {
        this(fmgr, host, x, y, glassImage, topImage, topRect, new Point(0, 0), botImage, botRect, new Point(0, 0), sandTrickle);
    }

    public HourglassView(FrameManager fmgr, JComponent host, int x, int y, Mirage glassImage, Mirage topImage, Rectangle topRect, Point topOff, Mirage botImage, Rectangle botRect, Point botOff, MultiFrameImage sandTrickle) {
        super(fmgr, host, new Rectangle(x, y, glassImage.getWidth(), glassImage.getHeight()));
        this._topRect = topRect;
        this._topOff = topOff;
        this._botRect = botRect;
        this._botOff = botOff;
        this._hourglass = glassImage;
        this._sandTop = topImage;
        this._sandBottom = botImage;
        this._sandTrickle = sandTrickle;
        this._sandY = 0;
        this._changeThreshold = 1.0f / (float)this._bounds.height;
    }

    public void changeComplete(float complete) {
        super.changeComplete(complete);
        this.setSandTrickleY();
    }

    public void tick(long tickStamp) {
        super.tick(tickStamp);
        if (this._enabled && this._running && tickStamp > this._sandStamp) {
            this.setSandTrickleY();
            this._sandFrame = (this._sandFrame + 1) % this._sandTrickle.getFrameCount();
            this._sandStamp = tickStamp + 80L;
            this.invalidate();
        }
    }

    public void paint(Graphics2D gfx, float completed) {
        super.paint(gfx, completed);
        gfx.translate(this._bounds.x, this._bounds.y);
        this._hourglass.paint(gfx, 0, 0);
        Shape oclip = gfx.getClip();
        int top = this._topRect.y + (int)((float)this._topRect.height * completed);
        gfx.clipRect(this._topRect.x, top, this._topRect.width, this._topRect.height - (top - this._topRect.y));
        this._sandTop.paint(gfx, this._topOff.x, this._topOff.y);
        gfx.setClip(oclip);
        int sandtop = this._topRect.y + this._topRect.height;
        if (this._sandY < this._botRect.height) {
            gfx.clipRect(this._botRect.x, sandtop, this._botRect.width, this._sandY);
        }
        this._sandTrickle.paintFrame(gfx, this._sandFrame, this._botRect.x + (this._botRect.width - this._sandTrickle.getWidth(this._sandFrame)) / 2, sandtop);
        gfx.setClip(oclip);
        top = this.getSandBottomTop(completed);
        gfx.clipRect(this._botRect.x, top, this._botRect.width, this._botRect.height - (top - this._botRect.y));
        this._sandBottom.paint(gfx, this._botOff.x, this._botOff.y);
        gfx.setClip(oclip);
        gfx.translate(-this._bounds.x, -this._bounds.y);
    }

    protected void setSandTrickleY() {
        this._sandY = (int)((double)this._botRect.height * Math.min(1.0, (double)this._complete / 0.025));
    }

    protected int getSandBottomTop(float completed) {
        return this._botRect.y + this._botRect.height - (int)((float)this._botRect.height * completed);
    }
}

