/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.threerings.media.FrameManager;
import com.threerings.media.FrameParticipant;
import java.awt.Component;

public abstract class FrameInterval
implements FrameParticipant {
    protected long _nextTime;
    protected long _repeatDelay;
    protected long _initDelay;
    protected FrameManager _mgr;

    public FrameInterval(FrameManager mgr) {
        this._mgr = mgr;
    }

    public Component getComponent() {
        return null;
    }

    public boolean needsPaint() {
        return false;
    }

    public void tick(long tickStamp) {
        if (this._nextTime == -1L) {
            this._nextTime = tickStamp + this._initDelay;
        } else if (tickStamp >= this._nextTime) {
            if (this._repeatDelay != 0L) {
                this._nextTime += this._repeatDelay;
            } else {
                this._nextTime = -1L;
                this.cancel();
            }
            this.expired();
        }
    }

    public abstract void expired();

    public final void schedule(long delay) {
        this.schedule(delay, 0L);
    }

    public final void schedule(long delay, boolean repeat) {
        this.schedule(delay, repeat ? delay : 0L);
    }

    public final void schedule(long initialDelay, long repeatDelay) {
        if (!this._mgr.isRegisteredFrameParticipant(this)) {
            this._mgr.registerFrameParticipant(this);
        }
        this._repeatDelay = repeatDelay;
        this._initDelay = initialDelay;
        this._nextTime = -1L;
    }

    public final void cancel() {
        this._mgr.removeFrameParticipant(this);
    }
}

