/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.bundle;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.IntIntMap;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.Tuple;
import com.threerings.cast.ActionFrames;
import com.threerings.cast.ActionSequence;
import com.threerings.cast.CharacterComponent;
import com.threerings.cast.ComponentClass;
import com.threerings.cast.ComponentRepository;
import com.threerings.cast.FrameProvider;
import com.threerings.cast.Log;
import com.threerings.cast.NoSuchComponentException;
import com.threerings.cast.TrimmedMultiFrameImage;
import com.threerings.cast.bundle.BundleUtil;
import com.threerings.media.image.BufferedMirage;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageDataProvider;
import com.threerings.media.image.ImageManager;
import com.threerings.media.image.Mirage;
import com.threerings.media.tile.IMImageProvider;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TrimmedTile;
import com.threerings.resource.FileResourceBundle;
import com.threerings.resource.ResourceBundle;
import com.threerings.resource.ResourceManager;
import com.threerings.util.DirectionCodes;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundledComponentRepository
implements DirectionCodes,
ComponentRepository {
    protected ImageManager _imgr;
    protected Map<String, ActionSequence> _actions;
    protected Map<String, TileSet> _actionSets;
    protected Map<String, ComponentClass> _classes;
    protected Map<String, ArrayList<CharacterComponent>> _classComps = Maps.newHashMap();
    protected IntMap<CharacterComponent> _components = IntMaps.newHashIntMap();
    protected boolean _wipeOnFailure;

    public BundledComponentRepository(ResourceManager rmgr, ImageManager imgr, String name) throws IOException {
        this._imgr = imgr;
        ResourceBundle[] rbundles = rmgr.getResourceSet(name);
        if (rbundles == null) {
            this._actions = Maps.newHashMap();
            this._classes = Maps.newHashMap();
            return;
        }
        try {
            for (ResourceBundle rbundle : rbundles) {
                Map cmap;
                if (this._actions == null) {
                    Map amap;
                    this._actions = amap = (Map)BundleUtil.loadObject(rbundle, "actions.dat", true);
                }
                if (this._actionSets == null) {
                    Map asets;
                    this._actionSets = asets = (Map)BundleUtil.loadObject(rbundle, "action_sets.dat", true);
                }
                if (this._classes != null) continue;
                this._classes = cmap = (Map)BundleUtil.loadObject(rbundle, "classes.dat", true);
            }
            for (ResourceBundle rbundle : rbundles) {
                IntMap comps = (IntMap)BundleUtil.loadObject(rbundle, "components.dat", true);
                if (comps == null) continue;
                ResourceBundleProvider fprov = new ResourceBundleProvider(this._imgr, rbundle);
                Iterator iter = comps.keySet().iterator();
                while (iter.hasNext()) {
                    int componentId = (Integer)iter.next();
                    Tuple info = (Tuple)comps.get(componentId);
                    this.createComponent(componentId, (String)info.left, (String)info.right, fprov);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw (IOException)new IOException("Internal error unserializing metadata").initCause(cnfe);
        }
        if (this._actions == null) {
            this._actions = Maps.newHashMap();
        }
        if (this._classes == null) {
            this._classes = Maps.newHashMap();
        }
    }

    public void setWipeOnFailure(boolean wipeOnFailure) {
        this._wipeOnFailure = wipeOnFailure;
    }

    @Override
    public CharacterComponent getComponent(int componentId) throws NoSuchComponentException {
        CharacterComponent component = (CharacterComponent)this._components.get(componentId);
        if (component == null) {
            throw new NoSuchComponentException(componentId);
        }
        return component;
    }

    @Override
    public CharacterComponent getComponent(String className, String compName) throws NoSuchComponentException {
        ArrayList<CharacterComponent> comps = this._classComps.get(className);
        if (comps != null) {
            int ccount = comps.size();
            for (int ii = 0; ii < ccount; ++ii) {
                CharacterComponent comp = comps.get(ii);
                if (!comp.name.equals(compName)) continue;
                return comp;
            }
        }
        throw new NoSuchComponentException(className, compName);
    }

    @Override
    public ComponentClass getComponentClass(String className) {
        return this._classes.get(className);
    }

    @Override
    public Iterator<ComponentClass> enumerateComponentClasses() {
        return this._classes.values().iterator();
    }

    @Override
    public Iterator<ActionSequence> enumerateActionSequences() {
        return this._actions.values().iterator();
    }

    @Override
    public Iterator<Integer> enumerateComponentIds(final ComponentClass compClass) {
        Predicate<Map.Entry<Integer, CharacterComponent>> pred = new Predicate<Map.Entry<Integer, CharacterComponent>>(){

            public boolean apply(Map.Entry<Integer, CharacterComponent> entry) {
                return entry.getValue().componentClass.equals(compClass);
            }
        };
        Function<Map.Entry<Integer, CharacterComponent>, Integer> func = new Function<Map.Entry<Integer, CharacterComponent>, Integer>(){

            public Integer apply(Map.Entry<Integer, CharacterComponent> entry) {
                return entry.getKey();
            }
        };
        return Iterators.transform((Iterator)Iterators.filter(this._components.entrySet().iterator(), (Predicate)pred), (Function)func);
    }

    protected void createComponent(int componentId, String cclass, String cname, FrameProvider fprov) {
        ComponentClass clazz = this._classes.get(cclass);
        if (clazz == null) {
            Log.log.warning((Object)"Non-existent component class", new Object[]{"class", cclass, "name", cname, "id", componentId});
            return;
        }
        CharacterComponent component = new CharacterComponent(componentId, cname, clazz, fprov);
        this._components.put(componentId, (Object)component);
        ArrayList comps = this._classComps.get(cclass);
        if (comps == null) {
            comps = Lists.newArrayList();
            this._classComps.put(cclass, comps);
        }
        if (!comps.contains(component)) {
            comps.add(component);
        } else {
            Log.log.info((Object)"Requested to register the same component twice?", new Object[]{"comp", component});
        }
    }

    protected TileSetFrameImage createTileSetFrameImage(TileSet aset, ActionSequence actseq) {
        return new TileSetFrameImage(aset, actseq);
    }

    public static class TileSetFrameImage
    implements ActionFrames {
        protected TileSet _set;
        protected ActionSequence _actseq;
        protected int _dx;
        protected int _dy;
        protected int _fcount;
        protected int _ocount;
        protected IntIntMap _orients = new IntIntMap();

        public TileSetFrameImage(TileSet set, ActionSequence actseq) {
            this(set, actseq, 0, 0);
        }

        public TileSetFrameImage(TileSet set, ActionSequence actseq, int dx, int dy) {
            this._set = set;
            this._actseq = actseq;
            this._dx = dx;
            this._dy = dy;
            this._ocount = actseq.orients.length;
            this._fcount = set.getTileCount() / this._ocount;
            for (int ii = 0; ii < this._ocount; ++ii) {
                this._orients.put(actseq.orients[ii], ii);
            }
        }

        public int getOrientationCount() {
            return this._ocount;
        }

        public TrimmedMultiFrameImage getFrames(final int orient) {
            return new TrimmedMultiFrameImage(){

                public int getFrameCount() {
                    return TileSetFrameImage.this._fcount;
                }

                public int getWidth(int index) {
                    return TileSetFrameImage.this._set.getTile(TileSetFrameImage.this.getTileIndex(orient, index)).getWidth();
                }

                public int getHeight(int index) {
                    return TileSetFrameImage.this._set.getTile(TileSetFrameImage.this.getTileIndex(orient, index)).getHeight();
                }

                public void paintFrame(Graphics2D g, int index, int x, int y) {
                    TileSetFrameImage.this.paintTile(g, orient, index, x, y);
                }

                public boolean hitTest(int index, int x, int y) {
                    return TileSetFrameImage.this._set.getTile(TileSetFrameImage.this.getTileIndex(orient, index)).hitTest(x + TileSetFrameImage.this._dx, y + TileSetFrameImage.this._dy);
                }

                public void getTrimmedBounds(int index, Rectangle bounds) {
                    TileSetFrameImage.this.getTrimmedBounds(orient, index, bounds);
                }
            };
        }

        protected void paintTile(Graphics2D g, int orient, int index, int x, int y) {
            this._set.getTile(this.getTileIndex(orient, index)).paint(g, x + this._dx, y + this._dy);
        }

        public void getTrimmedBounds(int orient, int index, Rectangle bounds) {
            Tile tile = this.getTile(orient, index);
            if (tile instanceof TrimmedTile) {
                ((TrimmedTile)tile).getTrimmedBounds(bounds);
            } else {
                bounds.setBounds(0, 0, tile.getWidth(), tile.getHeight());
            }
            bounds.translate(this._dx, this._dy);
        }

        public int getXOrigin(int orient, int index) {
            return this._actseq.origin.x;
        }

        public int getYOrigin(int orient, int index) {
            return this._actseq.origin.y;
        }

        public ActionFrames cloneColorized(Colorization[] zations) {
            return new TileSetFrameImage(this._set.clone(zations), this._actseq);
        }

        public ActionFrames cloneTranslated(int dx, int dy) {
            return new TileSetFrameImage(this._set, this._actseq, dx, dy);
        }

        protected int getTileIndex(int orient, int index) {
            return this._orients.get(orient) * this._fcount + index;
        }

        public Tile getTile(int orient, int index) {
            return this._set.getTile(this.getTileIndex(orient, index));
        }

        public Mirage getTileMirage(int orient, int index) {
            return this._set.getTileMirage(this.getTileIndex(orient, index));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ResourceBundleProvider
    extends IMImageProvider
    implements ImageDataProvider,
    FrameProvider {
        protected ResourceBundle _bundle;
        protected Map<String, TileSet> _setcache;

        public ResourceBundleProvider(ImageManager imgr, ResourceBundle bundle) {
            super(imgr, (String)null);
            this._setcache = Maps.newHashMap();
            this._dprov = this;
            this._bundle = bundle;
        }

        @Override
        public String getIdent() {
            return "bcr:" + this._bundle.getIdent();
        }

        @Override
        public BufferedImage loadImage(String path) throws IOException {
            return this._bundle.getImageResource(path, true);
        }

        @Override
        public ActionFrames getFrames(CharacterComponent component, String action, String type) {
            ActionSequence actseq = BundledComponentRepository.this._actions.get(action);
            if (actseq == null) {
                Log.log.warning((Object)"Missing action sequence definition", new Object[]{"action", action, "component", component});
                return null;
            }
            String imgpath = action;
            String dimgpath = "default";
            if (type != null) {
                imgpath = imgpath + "_" + type;
                dimgpath = dimgpath + "_" + type;
            }
            String root = component.componentClass.name + "/" + component.name + "/";
            String cpath = root + imgpath + ".dat";
            String dpath = root + dimgpath + ".dat";
            TileSet aset = this._setcache.get(cpath);
            if (aset == null && (aset = this._setcache.get(dpath)) != null) {
                this._setcache.put(cpath, aset);
            }
            try {
                if (aset == null) {
                    aset = (TileSet)BundleUtil.loadObject(this._bundle, cpath, false);
                }
                if (aset == null) {
                    aset = (TileSet)BundleUtil.loadObject(this._bundle, dpath, false);
                    this._setcache.put(dpath, aset);
                }
                if (aset == null) {
                    if (!"crop".equals(type) && !"shadow".equals(type)) {
                        Log.log.warning((Object)("Unable to locate tileset for action '" + imgpath + "' " + component + "."), new Object[0]);
                        if (BundledComponentRepository.this._wipeOnFailure && this._bundle instanceof FileResourceBundle) {
                            ((FileResourceBundle)this._bundle).wipeBundle(false);
                        }
                    }
                    return null;
                }
                aset.setImageProvider(this);
                this._setcache.put(cpath, aset);
                return BundledComponentRepository.this.createTileSetFrameImage(aset, actseq);
            }
            catch (Exception e) {
                Log.log.warning((Object)("Error loading tset for action '" + imgpath + "' " + component + "."), new Object[]{e});
                return null;
            }
        }

        @Override
        public String getFramePath(CharacterComponent component, String action, String type, Set<String> existentPaths) {
            String actionPath = this.makePath(component, action, type);
            if (!existentPaths.contains(actionPath)) {
                return this.makePath(component, "default", type);
            }
            return actionPath;
        }

        protected String makePath(CharacterComponent component, String action, String type) {
            String imgpath = action;
            if (type != null) {
                imgpath = imgpath + "_" + type;
            }
            String root = component.componentClass.name + "/" + component.name + "/";
            return this._bundle.getIdent() + root + imgpath + ".png";
        }

        @Override
        public Mirage getTileImage(String path, Rectangle bounds, Colorization[] zations) {
            BufferedImage src = this._imgr.getImage(this.getImageKey(path), zations);
            float percentageOfDataBuffer = 1.0f;
            if (bounds != null) {
                percentageOfDataBuffer = (float)(bounds.height * bounds.width) / (float)(src.getHeight() * src.getWidth());
                src = src.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            return new BufferedMirage(src, percentageOfDataBuffer);
        }
    }
}

