/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.bundle;

import com.samskivert.io.StreamUtil;
import com.threerings.cast.Log;
import com.threerings.resource.FileResourceBundle;
import com.threerings.resource.ResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;

public class BundleUtil {
    public static final String ACTIONS_PATH = "actions.dat";
    public static final String ACTION_SETS_PATH = "action_sets.dat";
    public static final String CLASSES_PATH = "classes.dat";
    public static final String COMPONENTS_PATH = "components.dat";
    public static final String IMAGE_EXTENSION = ".png";
    public static final String TILESET_EXTENSION = ".dat";

    public static Object loadObject(ResourceBundle bundle, String path, boolean wipeOnFailure) throws IOException, ClassNotFoundException {
        InputStream bin = null;
        try {
            bin = bundle.getResource(path);
            if (bin == null) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = new ObjectInputStream(bin).readObject();
            return object;
        }
        catch (InvalidClassException ice) {
            Log.log.warning((Object)("Aiya! Serialized object is hosed [bundle=" + bundle + ", element=" + path + ", error=" + ice.getMessage() + "]."), new Object[0]);
            Object var5_8 = null;
            return var5_8;
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Error reading resource from bundle [bundle=" + bundle + ", path=" + path + ", wiping?=" + wipeOnFailure + "]."), new Object[0]);
            if (wipeOnFailure) {
                StreamUtil.close((InputStream)bin);
                bin = null;
                if (bundle instanceof FileResourceBundle) {
                    ((FileResourceBundle)bundle).wipeBundle(false);
                }
            }
            throw ioe;
        }
        finally {
            StreamUtil.close((InputStream)bin);
        }
    }
}

