/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.builder;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.threerings.cast.ComponentClass;
import com.threerings.cast.ComponentRepository;
import com.threerings.cast.builder.BuilderModelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderModel {
    protected HashMap<ComponentClass, Integer> _selected = Maps.newHashMap();
    protected HashMap<ComponentClass, ArrayList<Integer>> _components = Maps.newHashMap();
    protected ArrayList<ComponentClass> _classes = Lists.newArrayList();
    protected ArrayList<BuilderModelListener> _listeners = Lists.newArrayList();

    public BuilderModel(ComponentRepository crepo) {
        this.gatherComponentInfo(crepo);
    }

    public void addListener(BuilderModelListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    protected void notifyListeners(int event) {
        int size = this._listeners.size();
        for (int ii = 0; ii < size; ++ii) {
            this._listeners.get(ii).modelChanged(event);
        }
    }

    public List<ComponentClass> getComponentClasses() {
        return Collections.unmodifiableList(this._classes);
    }

    public List<Integer> getComponents(ComponentClass cclass) {
        List list = this._components.get(cclass);
        if (list == null) {
            list = Lists.newArrayList();
        }
        return list;
    }

    public int[] getSelectedComponents() {
        int[] values = new int[this._selected.size()];
        Iterator<Integer> iter = this._selected.values().iterator();
        int ii = 0;
        while (iter.hasNext()) {
            values[ii] = iter.next();
            ++ii;
        }
        return values;
    }

    public void setSelectedComponent(ComponentClass cclass, int cid) {
        this._selected.put(cclass, cid);
        this.notifyListeners(0);
    }

    protected void gatherComponentInfo(ComponentRepository crepo) {
        Iterators.addAll(this._classes, crepo.enumerateComponentClasses());
        for (int ii = 0; ii < this._classes.size(); ++ii) {
            ComponentClass cclass = this._classes.get(ii);
            Iterator<Integer> iter = crepo.enumerateComponentIds(cclass);
            while (iter.hasNext()) {
                Integer cid = iter.next();
                ArrayList clist = this._components.get(cclass);
                if (clist == null) {
                    clist = Lists.newArrayList();
                    this._components.put(cclass, clist);
                }
                clist.add((Integer)cid);
            }
        }
    }
}

