/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast;

import com.samskivert.util.StringUtil;
import com.threerings.media.image.Colorization;
import java.awt.Point;
import java.util.Arrays;

public class CharacterDescriptor {
    protected int[] _components;
    protected Colorization[][] _zations;
    protected Point[] _xlations;

    public CharacterDescriptor(int[] components, Colorization[][] zations) {
        this._components = components;
        this._zations = zations;
    }

    public int[] getComponentIds() {
        return this._components;
    }

    public Colorization[][] getColorizations() {
        return this._zations;
    }

    public void setColorizations(Colorization[][] zations) {
        this._zations = zations;
    }

    public Point[] getTranslations() {
        return this._xlations;
    }

    public void setTranslations(Point[] xlations) {
        this._xlations = xlations;
    }

    public int hashCode() {
        int code = 0;
        int clength = this._components.length;
        for (int ii = 0; ii < clength; ++ii) {
            code ^= this._components[ii];
        }
        return code;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CharacterDescriptor)) {
            return false;
        }
        CharacterDescriptor odesc = (CharacterDescriptor)other;
        if (!Arrays.equals(this._components, odesc._components)) {
            return false;
        }
        Colorization[][] zations = odesc._zations;
        if (zations == null && this._zations == null) {
            return true;
        }
        if (zations == null || this._zations == null) {
            return false;
        }
        int zlength = zations.length;
        if (zlength != this._zations.length) {
            return false;
        }
        for (int ii = 0; ii < zlength; ++ii) {
            if (Arrays.equals(this._zations[ii], zations[ii])) continue;
            return false;
        }
        return Arrays.equals(this._xlations, odesc._xlations);
    }

    public String toString() {
        return "[cids=" + StringUtil.toString((Object)this._components) + ", colors=" + StringUtil.toString((Object)this._zations) + "]";
    }
}

