/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.tools.xml;

import com.megginson.sax.DataWriter;
import com.samskivert.util.StringUtil;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.data.SimpleMisoSceneModel;
import com.threerings.tools.xml.NestableWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleMisoSceneWriter
implements NestableWriter {
    public static final String OUTER_ELEMENT = "miso";

    public void write(Object object, DataWriter writer) throws SAXException {
        SimpleMisoSceneModel model = (SimpleMisoSceneModel)object;
        writer.startElement(OUTER_ELEMENT);
        this.writeSceneData(model, writer);
        writer.endElement(OUTER_ELEMENT);
    }

    protected void writeSceneData(SimpleMisoSceneModel model, DataWriter writer) throws SAXException {
        writer.dataElement("width", Integer.toString(model.width));
        writer.dataElement("height", Integer.toString(model.height));
        writer.dataElement("viewwidth", Integer.toString(model.vwidth));
        writer.dataElement("viewheight", Integer.toString(model.vheight));
        writer.dataElement("base", StringUtil.toString((Object)model.baseTileIds, (String)"", (String)""));
        writer.startElement("objects");
        for (int ii = 0; ii < model.objectTileIds.length; ++ii) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "tileId", "", "", String.valueOf(model.objectTileIds[ii]));
            attrs.addAttribute("", "x", "", "", String.valueOf(model.objectXs[ii]));
            attrs.addAttribute("", "y", "", "", String.valueOf(model.objectYs[ii]));
            writer.emptyElement("", "object", "", (Attributes)attrs);
        }
        for (ObjectInfo info : model.objectInfo) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "tileId", "", "", String.valueOf(info.tileId));
            attrs.addAttribute("", "x", "", "", String.valueOf(info.x));
            attrs.addAttribute("", "y", "", "", String.valueOf(info.y));
            if (!StringUtil.isBlank((String)info.action)) {
                attrs.addAttribute("", "action", "", "", info.action);
            }
            if (info.priority != 0) {
                attrs.addAttribute("", "priority", "", "", String.valueOf(info.priority));
            }
            if (info.sx != 0 || info.sy != 0) {
                attrs.addAttribute("", "sx", "", "", String.valueOf(info.sx));
                attrs.addAttribute("", "sy", "", "", String.valueOf(info.sy));
                attrs.addAttribute("", "sorient", "", "", String.valueOf(info.sorient));
            }
            if (info.zations != 0) {
                attrs.addAttribute("", "zations", "", "", String.valueOf(info.zations));
            }
            writer.emptyElement("", "object", "", (Attributes)attrs);
        }
        writer.endElement("objects");
    }
}

