/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.tools.xml;

import com.samskivert.util.StringUtil;
import com.samskivert.xml.CallMethodSpecialRule;
import com.threerings.media.Log;
import com.threerings.media.tile.SwissArmyTileSet;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.tools.xml.TileSetRuleSet;
import java.awt.Dimension;
import java.awt.Point;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwissArmyTileSetRuleSet
extends TileSetRuleSet {
    @Override
    public void addRuleInstances(Digester digester) {
        super.addRuleInstances(digester);
        digester.addRule(this._path + "/widths", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] widths = StringUtil.parseIntArray((String)bodyText);
                ((SwissArmyTileSet)target).setWidths(widths);
            }
        });
        digester.addRule(this._path + "/heights", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] heights = StringUtil.parseIntArray((String)bodyText);
                ((SwissArmyTileSet)target).setHeights(heights);
            }
        });
        digester.addRule(this._path + "/tileCounts", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] tileCounts = StringUtil.parseIntArray((String)bodyText);
                ((SwissArmyTileSet)target).setTileCounts(tileCounts);
            }
        });
        digester.addRule(this._path + "/offsetPos", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] values = StringUtil.parseIntArray((String)bodyText);
                SwissArmyTileSet starget = (SwissArmyTileSet)target;
                if (values.length == 2) {
                    starget.setOffsetPos(new Point(values[0], values[1]));
                } else {
                    Log.log.warning((Object)("Invalid 'offsetPos' definition '" + bodyText + "'."), new Object[0]);
                }
            }
        });
        digester.addRule(this._path + "/gapSize", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] values = StringUtil.parseIntArray((String)bodyText);
                SwissArmyTileSet starget = (SwissArmyTileSet)target;
                if (values.length == 2) {
                    starget.setGapSize(new Dimension(values[0], values[1]));
                } else {
                    Log.log.warning((Object)("Invalid 'gapSize' definition '" + bodyText + "'."), new Object[0]);
                }
            }
        });
    }

    @Override
    public boolean isValid(Object target) {
        SwissArmyTileSet set = (SwissArmyTileSet)target;
        boolean valid = super.isValid(target);
        if (set.getWidths() == null) {
            Log.log.warning((Object)("Tile set definition missing valid <widths> element [set=" + set + "]."), new Object[0]);
            valid = false;
        }
        if (set.getHeights() == null) {
            Log.log.warning((Object)("Tile set definition missing valid <heights> element [set=" + set + "]."), new Object[0]);
            valid = false;
        }
        if (set.getTileCounts() == null) {
            Log.log.warning((Object)("Tile set definition missing valid <tileCounts> element [set=" + set + "]."), new Object[0]);
            valid = false;
        }
        return valid;
    }

    @Override
    protected Class<? extends TileSet> getTileSetClass() {
        return SwissArmyTileSet.class;
    }
}

