/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.tools;

import com.google.common.collect.Maps;
import com.samskivert.io.PersistenceException;
import com.samskivert.util.QuickSort;
import com.threerings.media.tile.TileSetIDBroker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFileTileSetIDBroker
implements TileSetIDBroker {
    protected File _mapfile;
    protected int _nextTileSetID;
    protected int _storedTileSetID;
    protected HashMap<String, Integer> _map;
    protected static final String SEP_STR = " := ";

    public MapFileTileSetIDBroker(File mapfile) throws PersistenceException {
        this._mapfile = mapfile;
        try {
            BufferedReader bin = new BufferedReader(new FileReader(mapfile));
            this._storedTileSetID = this._nextTileSetID = this.readInt(bin);
            this._map = Maps.newHashMap();
            MapFileTileSetIDBroker.readMapFile(bin, this._map);
            bin.close();
        }
        catch (FileNotFoundException fnfe) {
            this._map = Maps.newHashMap();
        }
        catch (Exception e) {
            String errmsg = "Failure reading map file.";
            throw new PersistenceException(errmsg, e);
        }
    }

    protected int readInt(BufferedReader bin) throws IOException {
        String line = bin.readLine();
        try {
            return Integer.parseInt(line);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Expected number, got '" + line + "'");
        }
    }

    public int getTileSetID(String tileSetName) throws PersistenceException {
        Integer tsid = this._map.get(tileSetName);
        if (tsid == null) {
            tsid = ++this._nextTileSetID;
            this._map.put(tileSetName, tsid);
        }
        return tsid;
    }

    public boolean tileSetMapped(String tileSetName) throws PersistenceException {
        return this._map.containsKey(tileSetName);
    }

    public void commit() throws PersistenceException {
        if (this._storedTileSetID == this._nextTileSetID) {
            return;
        }
        try {
            BufferedWriter bout = new BufferedWriter(new FileWriter(this._mapfile));
            String tline = "" + this._nextTileSetID;
            bout.write(tline, 0, tline.length());
            bout.newLine();
            MapFileTileSetIDBroker.writeMapFile(bout, this._map);
            bout.close();
        }
        catch (IOException ioe) {
            String errmsg = "Failure writing map file.";
            throw new PersistenceException(errmsg, (Exception)ioe);
        }
    }

    public static void readMapFile(BufferedReader bin, HashMap<String, Integer> map) throws IOException {
        String line;
        while ((line = bin.readLine()) != null) {
            int eidx = line.indexOf(SEP_STR);
            if (eidx == -1) {
                throw new IOException("Malformed line, no ' := ': '" + line + "'");
            }
            try {
                String code = line.substring(eidx + SEP_STR.length());
                map.put(line.substring(0, eidx), Integer.valueOf(code));
            }
            catch (NumberFormatException nfe) {
                String errmsg = "Malformed line, invalid code: '" + line + "'";
                throw new IOException(errmsg);
            }
        }
    }

    public static void writeMapFile(BufferedWriter bout, HashMap<String, Integer> map) throws IOException {
        String[] lines = new String[map.size()];
        Iterator<String> iter = map.keySet().iterator();
        int ii = 0;
        while (iter.hasNext()) {
            String key = iter.next();
            Integer value = map.get(key);
            lines[ii] = key + SEP_STR + value;
            ++ii;
        }
        QuickSort.sort((Comparable[])lines);
        for (String line : lines) {
            bout.write(line, 0, line.length());
            bout.newLine();
        }
        bout.flush();
    }

    protected boolean renameTileSet(String oldName, String newName) {
        Integer tsid = this._map.get(oldName);
        if (tsid != null) {
            this._map.put(newName, tsid);
            --this._storedTileSetID;
            return true;
        }
        return false;
    }

    protected Iterator<String> enumerateMappings() {
        return this._map.keySet().iterator();
    }
}

