/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.bundle.tools;

import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.bundle.BundleUtil;
import com.threerings.media.tile.bundle.TileSetBundle;
import com.threerings.resource.FileResourceBundle;
import com.threerings.resource.ResourceBundle;
import java.io.File;
import java.util.Iterator;

public class DumpBundle {
    public static void main(String[] args) {
        boolean dumpTiles = false;
        if (args.length < 1) {
            String usage = "Usage: DumpBundle [-tiles] (bundle.jar|tsbundle.dat) [...]";
            System.err.println(usage);
            System.exit(-1);
        }
        for (String arg : args) {
            if (arg.equals("-tiles")) {
                dumpTiles = true;
                continue;
            }
            File file = new File(arg);
            try {
                TileSetBundle tsb = null;
                if (arg.endsWith(".jar")) {
                    FileResourceBundle bundle = new FileResourceBundle(file);
                    tsb = BundleUtil.extractBundle((ResourceBundle)bundle);
                    tsb.init((ResourceBundle)bundle);
                } else {
                    tsb = BundleUtil.extractBundle((File)file);
                }
                Iterator tsids = tsb.enumerateTileSetIds();
                while (tsids.hasNext()) {
                    Integer tsid = (Integer)tsids.next();
                    TileSet set = tsb.getTileSet(tsid.intValue());
                    System.out.println(tsid + " => " + set);
                    if (!dumpTiles) continue;
                    int nn = set.getTileCount();
                    for (int t = 0; t < nn; ++t) {
                        System.out.println("  " + t + " => " + set.getTile(t));
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error dumping bundle [path=" + arg + ", error=" + e + "].");
                e.printStackTrace();
            }
        }
    }
}

