/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.tools.xml;

import com.samskivert.util.StringUtil;
import com.samskivert.xml.CallMethodSpecialRule;
import com.samskivert.xml.SetFieldRule;
import com.samskivert.xml.SetPropertyFieldsRule;
import com.threerings.cast.ActionSequence;
import com.threerings.util.DirectionUtil;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSetBase;

public class ActionRuleSet
extends RuleSetBase {
    public static final String ACTION_PATH = "/action";
    protected String _prefix;

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public void addRuleInstances(Digester digester) {
        digester.addObjectCreate(this._prefix + ACTION_PATH, ActionSequence.class.getName());
        digester.addRule(this._prefix + ACTION_PATH, (Rule)new SetPropertyFieldsRule());
        digester.addRule(this._prefix + ACTION_PATH + "/framesPerSecond", (Rule)new SetFieldRule("framesPerSecond"));
        CallMethodSpecialRule origin = new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) throws Exception {
                int[] coords = StringUtil.parseIntArray((String)bodyText);
                if (coords.length != 2) {
                    String errmsg = "Invalid <origin> specification '" + bodyText + "'.";
                    throw new Exception(errmsg);
                }
                ((ActionSequence)target).origin.setLocation(coords[0], coords[1]);
            }
        };
        digester.addRule(this._prefix + ACTION_PATH + "/origin", (Rule)origin);
        CallMethodSpecialRule orient = new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) throws Exception {
                ActionSequence seq = (ActionSequence)target;
                String[] ostrs = StringUtil.parseStringArray((String)bodyText);
                seq.orients = new int[ostrs.length];
                for (int ii = 0; ii < ostrs.length; ++ii) {
                    int orient = DirectionUtil.fromShortString((String)ostrs[ii]);
                    if (orient == -1) {
                        String errmsg = "Invalid orientation specification [index=" + ii + ", orient=" + ostrs[ii] + "].";
                        throw new Exception(errmsg);
                    }
                    seq.orients[ii] = orient;
                }
            }
        };
        digester.addRule(this._prefix + ACTION_PATH + "/orients", (Rule)orient);
    }

    public static String validate(ActionSequence seq) {
        if (StringUtil.isBlank((String)seq.name)) {
            return "Missing 'name' definition.";
        }
        if (seq.framesPerSecond == 0.0f) {
            return "Missing 'framesPerSecond' definition.";
        }
        if (seq.orients == null) {
            return "Missing 'orients' definition.";
        }
        return null;
    }
}

