//
// $Id$
//
// OOO GWT Utils - utilities for creating GWT applications
// Copyright (C) 2009-2010 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/ooo-gwt-utils/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.gwt.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;

import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

/**
 * An tool task to automatically generate <code>FooConstants.java</code> classes from
 * <code>FooConstants.properties</code> classes for GWT's i18n.
 */
public class ConstantsSync extends I18nTool
{
    @Override
    protected String generate (String pkg, String clazz, File propsFile)
        throws IOException
    {
        StringBuilder buf = new StringBuilder();
        buf.append("//\n");
        buf.append("// Generated by ConstantsSyncTask on ").append(new Date()).append("\n\n");
        buf.append("package ").append(pkg).append(";\n\n");
        buf.append("public interface ").append(clazz);
        buf.append(" extends com.google.gwt.i18n.client.ConstantsWithLookup\n");
        buf.append("{\n");

        Properties props = new Properties();
        props.load(new FileInputStream(propsFile));
        Enumeration<?> names = props.propertyNames();
        for (int method = 0; names.hasMoreElements(); method++) {
            if (method > 0) {
                buf.append("\n");
            }
            String key = String.valueOf(names.nextElement());
            buf.append("    // \"" + props.get(key) + "\"\n");
            buf.append("    String ").append(keyToMethod(key)).append(" ();\n");
        }
        buf.append("}\n");

        return buf.toString();
    }
}
