//
// $Id: Preconditions.java 239 2010-11-14 02:14:49Z samskivert $
//
// OOO GWT Utils - utilities for creating GWT applications
// Copyright (C) 2009-2010 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/ooo-gwt-utils/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.gwt.util;

/**
 * Provides precondition checking used by other utility classes.
 */
public class Preconditions
{
    /**
     * Checks that the supplied parameter is not null. Throws a {@link NullPointerException} if it
     * is, using the supplied `param` string to include an informative error message.
     */
    public static <T> T checkNotNull (T value, String param)
    {
        if (value == null) {
            throw new NullPointerException("Must supply non-null '" + param + "'.");
        }
        return value;
    }
}
