//
// $Id: MessagesLookup.java 206 2010-10-18 19:05:23Z karma@deadmoose.com $
//
// OOO GWT Utils - utilities for creating GWT applications
// Copyright (C) 2009-2010 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/ooo-gwt-utils/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.gwt.util;

import com.samskivert.text.MessageUtil;

/**
 * Dynamic message translation at run-time.
 */
public abstract class MessagesLookup
{
    public static @interface Lookup
    {
        /** The full class name of the Messages class backing our lookups. */
        String using ();
    }

    /**
     * Translate a compound key/params string. The compoundKey is compatible with Narya's
     * MessageBundle, with the exception that qualified keys are not supported.
     */
    public String xlate (String compoundKey)
    {
        // to be more efficient about creating unnecessary objects, check before splitting
        int tidx = compoundKey.indexOf('|');
        if (tidx == -1) {
            return get(compoundKey);

        } else {
            String key = compoundKey.substring(0, tidx);
            String[] args = MessageUtil.decompose(compoundKey.substring(tidx+1));
            for (int ii = 0; ii < args.length; ii++) {
                if (MessageUtil.isTainted(args[ii])) {
                    args[ii] = MessageUtil.untaint(args[ii]);
                } else {
                    args[ii] = xlate(args[ii]);
                }
            }
            return get(key, (Object[])args);
        }
    }

    /** Translate a key with any number of arguments, backed by the Lookup. */
    public String get (String key, Object... args)
    {
        // First make the key for GWT-friendly
        return fetch(key.replace('.', '_'), args);
    }

    /** This is typically generated by MessagesLookupGenerator. */
    protected abstract String fetch (String key, Object... args);
}
