/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.producer;

import com.taobao.gecko.core.util.ConcurrentHashSet;
import com.taobao.metamorphosis.client.MetaMessageSessionFactory;
import com.taobao.metamorphosis.client.RemotingClientWrapper;
import com.taobao.metamorphosis.client.producer.PartitionSelector;
import com.taobao.metamorphosis.client.producer.ProducerZooKeeper;
import com.taobao.metamorphosis.client.producer.SimpleMessageProducer;
import com.taobao.metamorphosis.client.producer.XAMessageProducer;
import com.taobao.metamorphosis.client.transaction.TransactionContext;
import com.taobao.metamorphosis.exception.InvalidBrokerException;
import com.taobao.metamorphosis.exception.MetaClientException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.transaction.xa.XAResource;

public class SimpleXAMessageProducer
extends SimpleMessageProducer
implements XAMessageProducer {
    final Set<String> publishedTopics = new ConcurrentHashSet();
    private String selectedServerUrl;
    private final Random rand = new Random();

    public SimpleXAMessageProducer(MetaMessageSessionFactory messageSessionFactory, RemotingClientWrapper remotingClient, PartitionSelector partitionSelector, ProducerZooKeeper producerZooKeeper, String sessionId) {
        super(messageSessionFactory, remotingClient, partitionSelector, producerZooKeeper, sessionId);
    }

    @Override
    public void publish(String topic) {
        super.publish(topic);
        if (this.publishedTopics.add(topic)) {
            this.selectedServerUrl = this.selectTransactionBroker();
        }
    }

    private String selectTransactionBroker() {
        ArrayList brokerUrls = new ArrayList();
        for (String topic : this.publishedTopics) {
            brokerUrls.add(this.producerZooKeeper.getServerUrlSetByTopic(topic));
        }
        Set<String> resultSet = SimpleXAMessageProducer.intersect(brokerUrls);
        if (resultSet.isEmpty()) {
            throw new InvalidBrokerException("Could not select a common broker url for  topics:" + this.publishedTopics);
        }
        Object[] urls = resultSet.toArray(new String[resultSet.size()]);
        Arrays.sort(urls);
        return urls[this.rand.nextInt(urls.length)];
    }

    static <T> Set<T> intersect(List<Set<T>> sets) {
        if (sets == null || sets.size() == 0) {
            return null;
        }
        Set<T> rt = sets.get(0);
        for (int i = 1; i < sets.size(); ++i) {
            HashSet<T> copy = new HashSet<T>(rt);
            copy.retainAll((Collection)sets.get(i));
            rt = copy;
        }
        return rt;
    }

    @Override
    public XAResource getXAResource() throws MetaClientException {
        TransactionContext xares = (TransactionContext)this.transactionContext.get();
        if (xares != null) {
            return xares;
        }
        this.beginTransaction();
        xares = (TransactionContext)this.transactionContext.get();
        xares.setServerUrl(this.selectedServerUrl);
        this.logLastSentInfo(this.selectedServerUrl);
        return xares;
    }
}

