/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension.storage;

import com.taobao.common.store.journal.IndexMap;
import com.taobao.common.store.journal.JournalStore;
import com.taobao.common.store.journal.OpItem;
import com.taobao.common.store.util.BytesKey;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MessageStore
extends JournalStore {
    public MessageStore(String path, String name) throws IOException {
        super(path, name, (IndexMap)new MessageIndexMap(), false, false, false);
    }

    static class MessageIndexMap
    implements IndexMap {
        private final Lock lock = new ReentrantLock();
        private final Map<BytesKey, OpItem> map = new LinkedHashMap<BytesKey, OpItem>();

        MessageIndexMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(BytesKey key, OpItem opItem) {
            this.lock.lock();
            try {
                this.map.put(key, opItem);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(BytesKey key) {
            this.lock.lock();
            try {
                this.map.remove(key);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OpItem get(BytesKey key) {
            this.lock.lock();
            try {
                OpItem opItem = this.map.get(key);
                return opItem;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            this.lock.lock();
            try {
                int n = this.map.size();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(BytesKey key) {
            this.lock.lock();
            try {
                boolean bl = this.map.containsKey(key);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator<BytesKey> keyIterator() {
            this.lock.lock();
            try {
                MessageIndexMapItreator messageIndexMapItreator = new MessageIndexMapItreator(new LinkedHashSet<BytesKey>(this.map.keySet()).iterator());
                return messageIndexMapItreator;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map<BytesKey, OpItem> map) {
            this.lock.lock();
            try {
                this.map.putAll(map);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            this.lock.lock();
            try {
                this.map.clear();
            }
            finally {
                this.lock.unlock();
            }
        }

        class MessageIndexMapItreator
        implements Iterator<BytesKey> {
            private final Iterator<BytesKey> mapIterator;
            private BytesKey currentKey;

            MessageIndexMapItreator(Iterator<BytesKey> mapIterator) {
                this.mapIterator = mapIterator;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                MessageIndexMap.this.lock.lock();
                try {
                    if (this.mapIterator.hasNext()) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    MessageIndexMap.this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BytesKey next() {
                MessageIndexMap.this.lock.lock();
                try {
                    BytesKey result = null;
                    this.currentKey = result = this.mapIterator.next();
                    BytesKey bytesKey = result;
                    return bytesKey;
                }
                finally {
                    MessageIndexMap.this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                MessageIndexMap.this.lock.lock();
                try {
                    if (this.currentKey == null) {
                        throw new IllegalStateException("The next method is not been called");
                    }
                    MessageIndexMap.this.remove(this.currentKey);
                }
                finally {
                    MessageIndexMap.this.lock.unlock();
                }
            }
        }
    }
}

