/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension.producer;

import com.taobao.metamorphosis.Message;
import com.taobao.metamorphosis.client.extension.producer.AvailablePartitionNumException;
import com.taobao.metamorphosis.client.extension.producer.OrderedMessageProducer;
import com.taobao.metamorphosis.client.producer.SendResult;
import com.taobao.metamorphosis.cluster.Partition;
import com.taobao.metamorphosis.exception.MetaClientException;
import java.util.concurrent.TimeUnit;

class OrderedMessageSender {
    private final OrderedMessageProducer producer;

    OrderedMessageSender(OrderedMessageProducer producer) {
        this.producer = producer;
    }

    SendResult sendMessage(Message message, long timeout, TimeUnit unit) throws MetaClientException, InterruptedException {
        int maxRecheck = 3;
        int check = 1;
        SelectPartitionResult result;
        while ((result = this.trySelectPartition(message)).isPartitionWritable()) {
            int localMessageCount = this.producer.getLocalMessageCount(message.getTopic(), result.getSelectedPartition());
            if (localMessageCount > 0) {
                this.producer.tryRecoverMessage(message.getTopic(), result.getSelectedPartition());
            }
            if (localMessageCount <= 0) {
                return this.producer.sendMessageToServer(message, timeout, unit, true);
            }
            if (localMessageCount > 0 && localMessageCount <= 20) {
                if (check >= maxRecheck) {
                    return this.producer.saveMessageToLocal(message, result.getSelectedPartition(), timeout, unit);
                }
            } else {
                return this.producer.saveMessageToLocal(message, result.getSelectedPartition(), timeout, unit);
            }
            Thread.sleep(100L);
            ++check;
        }
        return this.producer.saveMessageToLocal(message, result.getSelectedPartition(), timeout, unit);
    }

    private SelectPartitionResult trySelectPartition(Message message) throws MetaClientException {
        SelectPartitionResult result = new SelectPartitionResult();
        try {
            Partition partition = this.producer.selectPartition(message);
            if (partition == null) {
                throw new MetaClientException("selected null partition");
            }
            result.setSelectedPartition(partition);
            result.setPartitionWritable(true);
        }
        catch (AvailablePartitionNumException e) {
            String msg = e.getMessage();
            String partitionStr = msg.substring(msg.indexOf("[") + 1, msg.indexOf("]"));
            result.setSelectedPartition(new Partition(partitionStr));
            result.setPartitionWritable(false);
        }
        catch (MetaClientException e) {
            throw e;
        }
        return result;
    }

    private static class SelectPartitionResult {
        private boolean partitionWritable;
        private Partition selectedPartition;

        private SelectPartitionResult() {
        }

        public boolean isPartitionWritable() {
            return this.partitionWritable;
        }

        public void setPartitionWritable(boolean partitionWritable) {
            this.partitionWritable = partitionWritable;
        }

        public Partition getSelectedPartition() {
            return this.selectedPartition;
        }

        public void setSelectedPartition(Partition selectedPartition) {
            this.selectedPartition = selectedPartition;
        }
    }
}

