/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension.producer;

import com.taobao.metamorphosis.Message;
import com.taobao.metamorphosis.client.MetaMessageSessionFactory;
import com.taobao.metamorphosis.client.RemotingClientWrapper;
import com.taobao.metamorphosis.client.extension.producer.MessageRecoverManager;
import com.taobao.metamorphosis.client.extension.producer.OrderedMessageSender;
import com.taobao.metamorphosis.client.producer.PartitionSelector;
import com.taobao.metamorphosis.client.producer.ProducerZooKeeper;
import com.taobao.metamorphosis.client.producer.SendResult;
import com.taobao.metamorphosis.client.producer.SimpleMessageProducer;
import com.taobao.metamorphosis.cluster.Partition;
import com.taobao.metamorphosis.exception.MetaClientException;
import com.taobao.metamorphosis.exception.MetaOpeartionTimeoutException;
import com.taobao.metamorphosis.utils.HexSupport;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderedMessageProducer
extends SimpleMessageProducer {
    private static final Log log = LogFactory.getLog(OrderedMessageProducer.class);
    private final MessageRecoverManager localMessageStorageManager;
    private final OrderedMessageSender orderMessageSender;
    private final boolean sendFailAndSaveToLocal = Boolean.parseBoolean(System.getProperty("meta.ordered.saveToLocalWhenFailed", "false"));
    private final MessageRecoverManager.MessageRecoverer recoverer = new MessageRecoverManager.MessageRecoverer(){

        @Override
        public void handle(Message msg) throws Exception {
            SendResult sendResult = OrderedMessageProducer.this.sendMessageToServer(msg, 3000L, TimeUnit.MILLISECONDS);
            if (!sendResult.isSuccess()) {
                throw new MetaClientException(sendResult.getErrorMessage());
            }
        }
    };

    public OrderedMessageProducer(MetaMessageSessionFactory messageSessionFactory, RemotingClientWrapper remotingClient, PartitionSelector partitionSelector, ProducerZooKeeper producerZooKeeper, String sessionId, MessageRecoverManager localMessageStorageManager) {
        super(messageSessionFactory, remotingClient, partitionSelector, producerZooKeeper, sessionId);
        this.localMessageStorageManager = localMessageStorageManager;
        this.orderMessageSender = new OrderedMessageSender(this);
    }

    @Override
    public void publish(String topic) {
        super.publish(topic);
        this.localMessageStorageManager.setMessageRecoverer(this.recoverer);
    }

    @Override
    public SendResult sendMessage(Message message, long timeout, TimeUnit unit) throws MetaClientException, InterruptedException {
        this.checkState();
        this.checkMessage(message);
        return this.orderMessageSender.sendMessage(message, timeout, unit);
    }

    Partition selectPartition(Message message) throws MetaClientException {
        return this.producerZooKeeper.selectPartition(message.getTopic(), message, this.partitionSelector);
    }

    SendResult saveMessageToLocal(Message message, Partition partition, long timeout, TimeUnit unit) {
        try {
            this.localMessageStorageManager.append(message, partition);
            return new SendResult(true, partition, -1L, "send to local");
        }
        catch (IOException e) {
            log.error((Object)("send message to local failed,topic=" + message.getTopic() + ",content[" + HexSupport.toHexFromBytes((byte[])message.getData()) + "]"));
            return new SendResult(false, null, -1L, "send message to local failed");
        }
    }

    SendResult sendMessageToServer(Message message, long timeout, TimeUnit unit, boolean saveToLocalWhileForbidden) throws MetaClientException, InterruptedException, MetaOpeartionTimeoutException {
        SendResult sendResult = this.sendMessageToServer(message, timeout, unit);
        if (this.needSaveToLocalWhenSendFailed(sendResult) || this.needSaveToLocalWhenForbidden(saveToLocalWhileForbidden, sendResult)) {
            log.warn((Object)("send to server fail,save to local." + sendResult.getErrorMessage()));
            return this.saveMessageToLocal(message, Partition.RandomPartiton, timeout, unit);
        }
        return sendResult;
    }

    private boolean needSaveToLocalWhenSendFailed(SendResult sendResult) {
        return !sendResult.isSuccess() && this.sendFailAndSaveToLocal;
    }

    private boolean needSaveToLocalWhenForbidden(boolean saveToLocalWhileForbidden, SendResult sendResult) {
        return !sendResult.isSuccess() && sendResult.getErrorMessage().equals(String.valueOf(403)) && saveToLocalWhileForbidden;
    }

    int getLocalMessageCount(String topic, Partition partition) {
        return this.localMessageStorageManager.getMessageCount(topic, partition);
    }

    void tryRecoverMessage(String topic, Partition partition) {
        this.localMessageStorageManager.recover(topic, partition, this.recoverer);
    }
}

