/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.consumer.storage;

import com.taobao.metamorphosis.client.ZkClientChangedListener;
import com.taobao.metamorphosis.client.consumer.TopicPartitionRegInfo;
import com.taobao.metamorphosis.client.consumer.storage.OffsetStorage;
import com.taobao.metamorphosis.cluster.Partition;
import com.taobao.metamorphosis.utils.MetaZookeeper;
import com.taobao.metamorphosis.utils.ZkUtils;
import java.util.Collection;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZkOffsetStorage
implements OffsetStorage,
ZkClientChangedListener {
    private volatile ZkClient zkClient;
    private final MetaZookeeper metaZookeeper;
    static final Log log = LogFactory.getLog(ZkOffsetStorage.class);

    @Override
    public void onZkClientChanged(ZkClient newClient) {
        log.info((Object)"Update ZkOffsetStorage's zkClient...");
        this.zkClient = newClient;
    }

    public ZkOffsetStorage(MetaZookeeper metaZookeeper, ZkClient zkClient) {
        this.metaZookeeper = metaZookeeper;
        this.zkClient = zkClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitOffset(String group, Collection<TopicPartitionRegInfo> infoList) {
        if (this.zkClient == null || infoList == null || infoList.isEmpty()) {
            return;
        }
        for (TopicPartitionRegInfo info : infoList) {
            String topic = info.getTopic();
            MetaZookeeper metaZookeeper = this.metaZookeeper;
            metaZookeeper.getClass();
            MetaZookeeper.ZKGroupTopicDirs topicDirs = new MetaZookeeper.ZKGroupTopicDirs(metaZookeeper, topic, group);
            long newOffset = -1L;
            long msgId = -1L;
            TopicPartitionRegInfo topicPartitionRegInfo = info;
            synchronized (topicPartitionRegInfo) {
                if (!info.isModified()) {
                    continue;
                }
                newOffset = info.getOffset().get();
                msgId = info.getMessageId();
                info.setModified(false);
            }
            try {
                ZkUtils.updatePersistentPath((ZkClient)this.zkClient, (String)(topicDirs.consumerOffsetDir + "/" + info.getPartition().toString()), (String)(msgId + "-" + newOffset));
            }
            catch (Throwable t) {
                log.error((Object)"exception during commitOffsets", t);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Committed offset " + newOffset + " for topic " + info.getTopic()));
        }
    }

    @Override
    public TopicPartitionRegInfo load(String topic, String group, Partition partition) {
        MetaZookeeper metaZookeeper = this.metaZookeeper;
        metaZookeeper.getClass();
        MetaZookeeper.ZKGroupTopicDirs topicDirs = new MetaZookeeper.ZKGroupTopicDirs(metaZookeeper, topic, group);
        String znode = topicDirs.consumerOffsetDir + "/" + partition.toString();
        String offsetString = ZkUtils.readDataMaybeNull((ZkClient)this.zkClient, (String)znode);
        if (offsetString == null) {
            return null;
        }
        int index = offsetString.lastIndexOf("-");
        if (index > 0) {
            long msgId = Long.parseLong(offsetString.substring(0, index));
            long offset = Long.parseLong(offsetString.substring(index + 1));
            return new TopicPartitionRegInfo(topic, partition, offset, msgId);
        }
        long offset = Long.parseLong(offsetString);
        return new TopicPartitionRegInfo(topic, partition, offset);
    }

    @Override
    public void close() {
    }

    @Override
    public void initOffset(String topic, String group, Partition partition, long offset) {
    }
}

