/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.consumer.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCUtils {
    static final Log log = LogFactory.getLog(JDBCUtils.class);

    public static Connection getConnection(DataSource ds) {
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new CannotGetConnectionException("Can not get connection from datasource", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(Connection conn, ConnectionCallback connectionCallBack) {
        try {
            if (connectionCallBack != null && conn != null) {
                Object object = connectionCallBack.doInConnection(conn);
                return object;
            }
        }
        catch (SQLException e) {
            log.error((Object)"doInConnection failed", (Throwable)e);
        }
        finally {
            JDBCUtils.close(conn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(PreparedStatement pstmt, PreparedStatementCallback pstmtCallBack) {
        try {
            if (pstmtCallBack != null && pstmt != null) {
                Object object = pstmtCallBack.doInPreparedStatement(pstmt);
                return object;
            }
        }
        catch (SQLException e) {
            log.error((Object)"doInPreparedStatement failed", (Throwable)e);
        }
        finally {
            JDBCUtils.close(pstmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(ResultSet rs, ResultSetCallback rsCallback) {
        try {
            if (rsCallback != null && rs != null) {
                Object object = rsCallback.doInResultSet(rs);
                return object;
            }
        }
        catch (SQLException e) {
            log.error((Object)"doInResultSet failed", (Throwable)e);
        }
        finally {
            JDBCUtils.close(rs);
        }
        return null;
    }

    public static void close(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.error((Object)"Close PreparedStatement failed", (Throwable)e);
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                log.error((Object)"Close ResultSet failed", (Throwable)ex);
            }
        }
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                log.error((Object)"Close connection failed", (Throwable)ex);
            }
        }
    }

    public static interface ResultSetCallback {
        public Object doInResultSet(ResultSet var1) throws SQLException;
    }

    public static interface PreparedStatementCallback {
        public Object doInPreparedStatement(PreparedStatement var1) throws SQLException;
    }

    public static interface ConnectionCallback {
        public Object doInConnection(Connection var1) throws SQLException;
    }

    public static class CannotGetConnectionException
    extends RuntimeException {
        static final long serialVersionUID = -1L;

        public CannotGetConnectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public CannotGetConnectionException(String message) {
            super(message);
        }
    }
}

