/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.consumer;

import com.taobao.metamorphosis.client.consumer.MessageListener;
import com.taobao.metamorphosis.client.consumer.SubscriberInfo;
import com.taobao.metamorphosis.exception.MetaClientException;
import java.util.concurrent.ConcurrentHashMap;

public class SubscribeInfoManager {
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, SubscriberInfo>> groupTopicSubcriberRegistry = new ConcurrentHashMap();

    public void subscribe(String topic, String group, int maxSize, MessageListener messageListener) throws MetaClientException {
        ConcurrentHashMap<String, SubscriberInfo> topicSubsriberRegistry = this.getTopicSubscriberRegistry(group);
        SubscriberInfo info = topicSubsriberRegistry.get(topic);
        if (info == null) {
            info = new SubscriberInfo(messageListener, maxSize);
            SubscriberInfo oldInfo = topicSubsriberRegistry.putIfAbsent(topic, info);
            if (oldInfo != null) {
                throw new MetaClientException("Topic=" + topic + " has been subscribered by group " + group);
            }
        } else {
            throw new MetaClientException("Topic=" + topic + " has been subscribered by group " + group);
        }
    }

    private ConcurrentHashMap<String, SubscriberInfo> getTopicSubscriberRegistry(String group) throws MetaClientException {
        ConcurrentHashMap<String, SubscriberInfo> old;
        ConcurrentHashMap<String, SubscriberInfo> topicSubsriberRegistry = this.groupTopicSubcriberRegistry.get(group);
        if (topicSubsriberRegistry == null && (old = this.groupTopicSubcriberRegistry.putIfAbsent(group, topicSubsriberRegistry = new ConcurrentHashMap())) != null) {
            topicSubsriberRegistry = old;
        }
        return topicSubsriberRegistry;
    }

    public MessageListener getMessageListener(String topic, String group) throws MetaClientException {
        ConcurrentHashMap<String, SubscriberInfo> topicSubsriberRegistry = this.groupTopicSubcriberRegistry.get(group);
        if (topicSubsriberRegistry == null) {
            return null;
        }
        SubscriberInfo info = topicSubsriberRegistry.get(topic);
        if (info == null) {
            return null;
        }
        return info.getMessageListener();
    }

    public void removeGroup(String group) {
        this.groupTopicSubcriberRegistry.remove(group);
    }

    ConcurrentHashMap<String, ConcurrentHashMap<String, SubscriberInfo>> getGroupTopicSubcriberRegistry() {
        return this.groupTopicSubcriberRegistry;
    }
}

