/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.consumer;

import com.taobao.metamorphosis.client.consumer.FetchRequest;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class FetchRequestQueue {
    private final LinkedList<FetchRequest> queue = new LinkedList();
    private final Lock lock = new ReentrantLock();
    private final Condition available = this.lock.newCondition();

    FetchRequestQueue() {
    }

    public FetchRequest take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (true) {
                FetchRequest first;
                if ((first = this.queue.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    long tl = this.available.awaitNanos(delay);
                    continue;
                }
                FetchRequest x = this.queue.poll();
                assert (x != null);
                if (this.queue.size() != 0) {
                    this.available.signalAll();
                }
                FetchRequest fetchRequest = x;
                return fetchRequest;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(FetchRequest request) {
        this.lock.lock();
        try {
            FetchRequest first = this.queue.peek();
            this.queue.offer(request);
            Collections.sort(this.queue);
            if (first == null || request.compareTo(first) < 0) {
                this.available.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

