/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.consumer;

import com.taobao.metamorphosis.client.consumer.LoadBalanceStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultLoadBalanceStrategy
implements LoadBalanceStrategy {
    static final Log log = LogFactory.getLog(DefaultLoadBalanceStrategy.class);

    @Override
    public List<String> getPartitions(String topic, String consumerId, List<String> curConsumers, List<String> curPartitions) {
        int nPartsPerConsumer = curPartitions.size() / curConsumers.size();
        int nConsumersWithExtraPart = curPartitions.size() % curConsumers.size();
        log.info((Object)("Consumer " + consumerId + " rebalancing the following partitions: " + curPartitions + " for topic " + topic + " with consumers: " + curConsumers));
        int myConsumerPosition = curConsumers.indexOf(consumerId);
        if (myConsumerPosition < 0) {
            log.warn((Object)("No broker partions consumed by consumer " + consumerId + " for topic " + topic));
            return Collections.emptyList();
        }
        assert (myConsumerPosition >= 0);
        int startPart = nPartsPerConsumer * myConsumerPosition + Math.min(myConsumerPosition, nConsumersWithExtraPart);
        int nParts = nPartsPerConsumer + (myConsumerPosition + 1 > nConsumersWithExtraPart ? 0 : 1);
        if (nParts <= 0) {
            log.warn((Object)("No broker partions consumed by consumer " + consumerId + " for topic " + topic));
            return Collections.emptyList();
        }
        ArrayList<String> rt = new ArrayList<String>();
        for (int i = startPart; i < startPart + nParts; ++i) {
            String partition = curPartitions.get(i);
            rt.add(partition);
        }
        return rt;
    }
}

