/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client;

import com.taobao.gecko.core.buffer.IoBuffer;
import com.taobao.gecko.core.command.RequestCommand;
import com.taobao.gecko.core.command.ResponseCommand;
import com.taobao.gecko.core.nio.impl.TimerRef;
import com.taobao.gecko.service.Connection;
import com.taobao.gecko.service.ConnectionLifeCycleListener;
import com.taobao.gecko.service.ConnectionSelector;
import com.taobao.gecko.service.GroupAllConnectionCallBackListener;
import com.taobao.gecko.service.MultiGroupCallBackListener;
import com.taobao.gecko.service.RemotingClient;
import com.taobao.gecko.service.RemotingContext;
import com.taobao.gecko.service.RequestProcessor;
import com.taobao.gecko.service.SingleRequestCallBackListener;
import com.taobao.gecko.service.config.ClientConfig;
import com.taobao.gecko.service.exception.NotifyRemotingException;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class RemotingClientWrapper
implements RemotingClient {
    private final RemotingClient remotingClient;
    private final ConcurrentHashMap<String, AtomicInteger> serverCounter = new ConcurrentHashMap();

    public RemotingClientWrapper(RemotingClient remotingClient) {
        this.remotingClient = remotingClient;
    }

    public void addAllProcessors(Map<Class<? extends RequestCommand>, RequestProcessor<? extends RequestCommand>> map) {
        this.remotingClient.addAllProcessors(map);
    }

    public void addConnectionLifeCycleListener(ConnectionLifeCycleListener connectionLifeCycleListener) {
        this.remotingClient.addConnectionLifeCycleListener(connectionLifeCycleListener);
    }

    public void awaitReadyInterrupt(String url, long time) throws NotifyRemotingException, InterruptedException {
        this.remotingClient.awaitReadyInterrupt(url, time);
    }

    public void awaitReadyInterrupt(String url) throws NotifyRemotingException, InterruptedException {
        this.remotingClient.awaitReadyInterrupt(url);
    }

    public void close(String url, boolean allowReconnect) throws NotifyRemotingException {
        AtomicInteger counter = this.serverCounter.get(url);
        if (counter.decrementAndGet() == 0) {
            this.remotingClient.close(url, allowReconnect);
        }
    }

    public void connect(String url, int connCount) throws NotifyRemotingException {
        AtomicInteger counter = this.getCounter(url);
        this.remotingClient.connect(url, connCount);
        counter.incrementAndGet();
    }

    private AtomicInteger getCounter(String url) {
        AtomicInteger oldCounter;
        AtomicInteger counter = this.serverCounter.get(url);
        if (counter == null && (oldCounter = this.serverCounter.putIfAbsent(url, counter = new AtomicInteger(0))) != null) {
            counter = oldCounter;
        }
        return counter;
    }

    public void connect(String url) throws NotifyRemotingException {
        AtomicInteger counter = this.getCounter(url);
        this.remotingClient.connect(url);
        counter.incrementAndGet();
    }

    public Object getAttribute(String group, String key) {
        return this.remotingClient.getAttribute(group, key);
    }

    public int getConnectionCount(String group) {
        return this.remotingClient.getConnectionCount(group);
    }

    public Set<String> getGroupSet() {
        return this.remotingClient.getGroupSet();
    }

    public RequestProcessor<? extends RequestCommand> getProcessor(Class<? extends RequestCommand> clazz) {
        return this.remotingClient.getProcessor(clazz);
    }

    public InetSocketAddress getRemoteAddress(String url) {
        return this.remotingClient.getRemoteAddress(url);
    }

    public String getRemoteAddressString(String url) {
        return this.remotingClient.getRemoteAddressString(url);
    }

    public RemotingContext getRemotingContext() {
        return this.remotingClient.getRemotingContext();
    }

    public void insertTimer(TimerRef timerRef) {
        this.remotingClient.insertTimer(timerRef);
    }

    public ResponseCommand invokeToGroup(String group, RequestCommand command, long time, TimeUnit timeUnit) throws InterruptedException, TimeoutException, NotifyRemotingException {
        return this.remotingClient.invokeToGroup(group, command, time, timeUnit);
    }

    public ResponseCommand invokeToGroup(String group, RequestCommand command) throws InterruptedException, TimeoutException, NotifyRemotingException {
        return this.remotingClient.invokeToGroup(group, command);
    }

    public Map<Connection, ResponseCommand> invokeToGroupAllConnections(String group, RequestCommand command, long time, TimeUnit timeUnit) throws InterruptedException, NotifyRemotingException {
        return this.remotingClient.invokeToGroupAllConnections(group, command, time, timeUnit);
    }

    public Map<Connection, ResponseCommand> invokeToGroupAllConnections(String group, RequestCommand command) throws InterruptedException, NotifyRemotingException {
        return this.remotingClient.invokeToGroupAllConnections(group, command);
    }

    public boolean isConnected(String url) {
        return this.remotingClient.isConnected(url);
    }

    public boolean isStarted() {
        return this.remotingClient.isStarted();
    }

    public <T extends RequestCommand> void registerProcessor(Class<T> commandClazz, RequestProcessor<T> processor) {
        this.remotingClient.registerProcessor(commandClazz, processor);
    }

    public Object removeAttribute(String group, String key) {
        return this.remotingClient.removeAttribute(group, key);
    }

    public void removeConnectionLifeCycleListener(ConnectionLifeCycleListener connectionLifeCycleListener) {
        this.remotingClient.removeConnectionLifeCycleListener(connectionLifeCycleListener);
    }

    public Connection selectConnectionForGroup(String group, ConnectionSelector connectionSelector, RequestCommand request) throws NotifyRemotingException {
        return this.remotingClient.selectConnectionForGroup(group, connectionSelector, request);
    }

    public void sendToAllConnections(RequestCommand command) throws NotifyRemotingException {
        this.remotingClient.sendToAllConnections(command);
    }

    public void sendToGroup(String group, RequestCommand command, SingleRequestCallBackListener listener, long time, TimeUnit timeunut) throws NotifyRemotingException {
        this.remotingClient.sendToGroup(group, command, listener, time, timeunut);
    }

    public void sendToGroup(String group, RequestCommand command, SingleRequestCallBackListener listener) throws NotifyRemotingException {
        this.remotingClient.sendToGroup(group, command, listener);
    }

    public void sendToGroup(String group, RequestCommand command) throws NotifyRemotingException {
        this.remotingClient.sendToGroup(group, command);
    }

    public void sendToGroupAllConnections(String group, RequestCommand command, GroupAllConnectionCallBackListener listener, long time, TimeUnit timeUnit) throws NotifyRemotingException {
        this.remotingClient.sendToGroupAllConnections(group, command, listener, time, timeUnit);
    }

    public void sendToGroupAllConnections(String group, RequestCommand command, GroupAllConnectionCallBackListener listener) throws NotifyRemotingException {
        this.remotingClient.sendToGroupAllConnections(group, command, listener);
    }

    public void sendToGroupAllConnections(String group, RequestCommand command) throws NotifyRemotingException {
        this.remotingClient.sendToGroupAllConnections(group, command);
    }

    public void sendToGroups(Map<String, RequestCommand> groupObjects, MultiGroupCallBackListener listener, long timeout, TimeUnit timeUnit, Object ... args) throws NotifyRemotingException {
        this.remotingClient.sendToGroups(groupObjects, listener, timeout, timeUnit, args);
    }

    public void sendToGroups(Map<String, RequestCommand> groupObjects) throws NotifyRemotingException {
        this.remotingClient.sendToGroups(groupObjects);
    }

    public void setAttribute(String group, String key, Object value) {
        this.remotingClient.setAttribute(group, key, value);
    }

    public Object setAttributeIfAbsent(String group, String key, Object value) {
        return this.remotingClient.setAttributeIfAbsent(group, key, value);
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.remotingClient.setClientConfig(clientConfig);
    }

    public void setConnectionSelector(ConnectionSelector selector) {
        this.remotingClient.setConnectionSelector(selector);
    }

    public void start() throws NotifyRemotingException {
        this.remotingClient.start();
    }

    public void stop() throws NotifyRemotingException {
        this.remotingClient.stop();
    }

    public RequestProcessor<? extends RequestCommand> unreigsterProcessor(Class<? extends RequestCommand> clazz) {
        return this.remotingClient.unreigsterProcessor(clazz);
    }

    public void transferToGroup(String group, IoBuffer head, IoBuffer tail, FileChannel channel, long position, long size, Integer opaque, SingleRequestCallBackListener listener, long time, TimeUnit unit) throws NotifyRemotingException {
        this.remotingClient.transferToGroup(group, head, tail, channel, position, size, opaque, listener, time, unit);
    }

    public void transferToGroup(String group, IoBuffer head, IoBuffer tail, FileChannel channel, long position, long size) throws NotifyRemotingException {
        this.remotingClient.transferToGroup(group, head, tail, channel, position, size);
    }
}

