/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.mustache;

import com.samskivert.mustache.MustacheException;
import com.samskivert.mustache.MustacheParseException;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Mustache {
    protected static final int TEXT = 0;
    protected static final int MATCHING_START = 1;
    protected static final int MATCHING_END = 2;
    protected static final int TAG = 3;
    protected static final String[][] ATTR_ESCAPES = new String[][]{{"&", "&amp;"}, {"'", "&apos;"}, {"\"", "&quot;"}, {"<", "&lt;"}, {">", "&gt;"}};
    protected static final char NO_CHAR = '\u0000';
    protected static final TemplateLoader FAILING_LOADER = new TemplateLoader(){

        public Reader getTemplate(String name) {
            throw new UnsupportedOperationException("Template loading not configured");
        }
    };

    public static Compiler compiler() {
        return new Compiler(true, false, null, true, FAILING_LOADER);
    }

    protected static Template compile(Reader source, Compiler compiler) {
        Accumulator accum = new Parser(compiler).parse(source);
        return new Template(accum.finish(), compiler);
    }

    private Mustache() {
    }

    protected static void restoreStartTag(StringBuilder text, Delims starts) {
        text.insert(0, starts.start1);
        if (starts.start2 != '\u0000') {
            text.insert(1, starts.start2);
        }
    }

    protected static String escapeHTML(String text) {
        for (String[] escape : ATTR_ESCAPES) {
            text = text.replace(escape[0], escape[1]);
        }
        return text;
    }

    protected static boolean allowsWhitespace(char typeChar) {
        return typeChar == '=' || typeChar == '!';
    }

    protected static class InvertedSectionSegment
    extends CompoundSegment {
        public InvertedSectionSegment(String name, Template.Segment[] segs, int line) {
            super(name, segs, line);
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Iterator iter;
            Object value = tmpl.getSectionValue(ctx, this._name, this._line);
            if (value instanceof Iterable) {
                Iterable iable = (Iterable)value;
                if (!iable.iterator().hasNext()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof Boolean) {
                if (!((Boolean)value).booleanValue()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value.getClass().isArray()) {
                if (Array.getLength(value) == 0) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof Iterator && !(iter = (Iterator)value).hasNext()) {
                this.executeSegs(tmpl, ctx, out);
            }
        }
    }

    protected static class SectionSegment
    extends CompoundSegment {
        public SectionSegment(String name, Template.Segment[] segs, int line) {
            super(name, segs, line);
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Iterator value = tmpl.getSectionValue(ctx, this._name, this._line);
            if (value instanceof Iterable) {
                value = ((Iterable)((Object)value)).iterator();
            }
            if (value instanceof Iterator) {
                int index = 0;
                Iterator iter = value;
                while (iter.hasNext()) {
                    Object elem = iter.next();
                    boolean onFirst = index == 0;
                    boolean onLast = !iter.hasNext();
                    this.executeSegs(tmpl, ctx.nest(elem, ++index, onFirst, onLast), out);
                }
            } else if (value instanceof Boolean) {
                if (((Boolean)((Object)value)).booleanValue()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value.getClass().isArray()) {
                int ll = Array.getLength(value);
                for (int ii = 0; ii < ll; ++ii) {
                    boolean onFirst = ii == 0;
                    boolean onLast = ii == ll - 1;
                    this.executeSegs(tmpl, ctx.nest(Array.get(value, ii), ii + 1, onFirst, onLast), out);
                }
            } else {
                this.executeSegs(tmpl, ctx.nest(value, 0, false, false), out);
            }
        }
    }

    protected static abstract class CompoundSegment
    extends NamedSegment {
        protected final Template.Segment[] _segs;

        protected CompoundSegment(String name, Template.Segment[] segs, int line) {
            super(name, line);
            this._segs = segs;
        }

        protected void executeSegs(Template tmpl, Template.Context ctx, Writer out) {
            for (Template.Segment seg : this._segs) {
                seg.execute(tmpl, ctx, out);
            }
        }
    }

    protected static class VariableSegment
    extends NamedSegment {
        protected boolean _escapeHTML;

        public VariableSegment(String name, boolean escapeHTML, int line) {
            super(name, line);
            this._escapeHTML = escapeHTML;
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Object value = tmpl.getValueOrDefault(ctx, this._name, this._line);
            if (value == null) {
                throw new MustacheException("No key, method or field with name '" + this._name + "' on line " + this._line);
            }
            String text = String.valueOf(value);
            VariableSegment.write(out, this._escapeHTML ? Mustache.escapeHTML(text) : text);
        }
    }

    protected static abstract class NamedSegment
    extends Template.Segment {
        protected final String _name;
        protected final int _line;

        protected NamedSegment(String name, int line) {
            this._name = name.intern();
            this._line = line;
        }
    }

    protected static class IncludedTemplateSegment
    extends Template.Segment {
        protected final Template _template;

        public IncludedTemplateSegment(String templateName, Compiler compiler) {
            Reader r;
            try {
                r = compiler.loader.getTemplate(templateName);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MustacheException("Unable to load template: " + templateName, e);
            }
            this._template = compiler.compile(r);
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            this._template.executeSegs(ctx, out);
        }
    }

    protected static class StringSegment
    extends Template.Segment {
        protected final String _text;

        public StringSegment(String text) {
            this._text = text;
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            StringSegment.write(out, this._text);
        }
    }

    protected static class Accumulator {
        protected Compiler _compiler;
        protected final List<Template.Segment> _segs = new ArrayList<Template.Segment>();

        public Accumulator(Compiler compiler) {
            this._compiler = compiler;
        }

        public boolean justOpenedOrClosedCompound() {
            return !this._segs.isEmpty() && this._segs.get(this._segs.size() - 1) instanceof CompoundSegment;
        }

        public void addTextSegment(StringBuilder text) {
            if (text.length() > 0) {
                this._segs.add(new StringSegment(text.toString()));
                text.setLength(0);
            }
        }

        public Accumulator addTagSegment(StringBuilder accum, final int tagLine) {
            final Accumulator outer = this;
            String tag = accum.toString().trim();
            final String tag1 = tag.substring(1).trim();
            accum.setLength(0);
            switch (tag.charAt(0)) {
                case '#': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._compiler){

                        public boolean justOpenedOrClosedCompound() {
                            return this._segs.isEmpty() || super.justOpenedOrClosedCompound();
                        }

                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Section missing close tag '" + tag1 + "'", tagLine);
                        }

                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            1.requireSameName(tag1, itag, line);
                            outer._segs.add(new SectionSegment(itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '>': {
                    this._segs.add(new IncludedTemplateSegment(tag1, this._compiler));
                    return this;
                }
                case '^': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._compiler){

                        public boolean justOpenedOrClosedCompound() {
                            return this._segs.isEmpty() || super.justOpenedOrClosedCompound();
                        }

                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Inverted section missing close tag '" + tag1 + "'", tagLine);
                        }

                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            2.requireSameName(tag1, itag, line);
                            outer._segs.add(new InvertedSectionSegment(itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '/': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return this.addCloseSectionSegment(tag1, tagLine);
                }
                case '!': {
                    return this;
                }
                case '&': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    this._segs.add(new VariableSegment(tag1, false, tagLine));
                    return this;
                }
            }
            Accumulator.requireNoNewlines(tag, tagLine);
            this._segs.add(new VariableSegment(tag, this._compiler.escapeHTML, tagLine));
            return this;
        }

        public Template.Segment[] finish() {
            return this._segs.toArray(new Template.Segment[this._segs.size()]);
        }

        protected Accumulator addCloseSectionSegment(String tag, int line) {
            throw new MustacheParseException("Section close tag with no open tag '" + tag + "'", line);
        }

        protected static void requireNoNewlines(String tag, int line) {
            if (tag.indexOf("\n") != -1 || tag.indexOf("\r") != -1) {
                throw new MustacheParseException("Invalid tag name: contains newline '" + tag + "'", line);
            }
        }

        protected static void requireSameName(String name1, String name2, int line) {
            if (!name1.equals(name2)) {
                throw new MustacheParseException("Section close tag with mismatched open tag '" + name2 + "' != '" + name1 + "'", line);
            }
        }
    }

    protected static class Delims {
        public char start1 = (char)123;
        public char start2 = (char)123;
        public char end1 = (char)125;
        public char end2 = (char)125;

        protected Delims() {
        }

        public boolean isDefault() {
            return this.start1 == '{' && this.start2 == '{' && this.end1 == '}' && this.end2 == '}';
        }

        public void updateDelims(String dtext) {
            String errmsg = "Invalid delimiter configuration '" + dtext + "'. Must be of the " + "form {{=1 2=}} or {{=12 34=}} where 1, 2, 3 and 4 are delimiter chars.";
            String[] delims = dtext.split(" ");
            if (delims.length != 2) {
                throw new MustacheException(errmsg);
            }
            switch (delims[0].length()) {
                case 1: {
                    this.start1 = delims[0].charAt(0);
                    this.start2 = '\u0000';
                    break;
                }
                case 2: {
                    this.start1 = delims[0].charAt(0);
                    this.start2 = delims[0].charAt(1);
                    break;
                }
                default: {
                    throw new MustacheException(errmsg);
                }
            }
            switch (delims[1].length()) {
                case 1: {
                    this.end1 = delims[1].charAt(0);
                    this.end2 = '\u0000';
                    break;
                }
                case 2: {
                    this.end1 = delims[1].charAt(0);
                    this.end2 = delims[1].charAt(1);
                    break;
                }
                default: {
                    throw new MustacheException(errmsg);
                }
            }
        }
    }

    protected static class Parser {
        final Delims delims = new Delims();
        final StringBuilder text = new StringBuilder();
        Reader source;
        Accumulator accum;
        int state = 0;
        int line = 1;
        int column = 0;
        int tagStartColumn = -1;
        boolean skipNewline = false;

        public Parser(Compiler compiler) {
            this.accum = new Accumulator(compiler);
        }

        public Accumulator parse(Reader source) {
            this.source = source;
            while (true) {
                char c;
                try {
                    int v = source.read();
                    if (v == -1) break;
                    c = (char)v;
                }
                catch (IOException e) {
                    throw new MustacheException(e);
                }
                if (c == '\n') {
                    this.column = 0;
                    ++this.line;
                    if (this.skipNewline) {
                        this.skipNewline = false;
                        continue;
                    }
                } else {
                    ++this.column;
                    this.skipNewline = false;
                }
                this.parseChar(c);
            }
            switch (this.state) {
                case 3: {
                    Mustache.restoreStartTag(this.text, this.delims);
                    break;
                }
                case 2: {
                    Mustache.restoreStartTag(this.text, this.delims);
                    this.text.append(this.delims.end1);
                    break;
                }
                case 1: {
                    this.text.append(this.delims.start1);
                }
            }
            this.accum.addTextSegment(this.text);
            return this.accum;
        }

        protected void parseChar(char c) {
            switch (this.state) {
                case 0: {
                    if (c == this.delims.start1) {
                        this.state = 1;
                        this.tagStartColumn = this.column;
                        if (this.delims.start2 != '\u0000') break;
                        this.parseChar('\u0000');
                        break;
                    }
                    this.text.append(c);
                    break;
                }
                case 1: {
                    if (c == this.delims.start2) {
                        this.accum.addTextSegment(this.text);
                        this.state = 3;
                        break;
                    }
                    this.text.append(this.delims.start1);
                    this.state = 0;
                    this.parseChar(c);
                    break;
                }
                case 3: {
                    if (c == this.delims.end1) {
                        this.state = 2;
                        if (this.delims.end2 != '\u0000') break;
                        this.parseChar('\u0000');
                        break;
                    }
                    if (c == this.delims.start1 && this.text.length() > 0) {
                        Mustache.restoreStartTag(this.text, this.delims);
                        this.accum.addTextSegment(this.text);
                        this.tagStartColumn = this.column;
                        if (this.delims.start2 == '\u0000') {
                            this.accum.addTextSegment(this.text);
                            this.state = 3;
                            break;
                        }
                        this.state = 1;
                        break;
                    }
                    this.text.append(c);
                    break;
                }
                case 2: {
                    if (c == this.delims.end2) {
                        if (this.text.charAt(0) == '=') {
                            this.delims.updateDelims(this.text.substring(1, this.text.length() - 1));
                            this.text.setLength(0);
                        } else {
                            if (this.delims.isDefault() && this.text.charAt(0) == this.delims.start1) {
                                try {
                                    char end3 = (char)this.source.read();
                                    if (end3 != '}') {
                                        throw new MustacheParseException("Invalid triple-mustache tag: {{{" + this.text + "}}", this.line);
                                    }
                                }
                                catch (IOException e) {
                                    throw new MustacheException(e);
                                }
                                this.text.replace(0, 1, "&");
                            }
                            this.accum = this.accum.addTagSegment(this.text, this.line);
                            this.skipNewline = this.tagStartColumn == 1 && this.accum.justOpenedOrClosedCompound();
                        }
                        this.state = 0;
                        break;
                    }
                    this.text.append(this.delims.end1);
                    this.state = 3;
                    this.parseChar(c);
                }
            }
        }
    }

    public static interface TemplateLoader {
        public Reader getTemplate(String var1) throws Exception;
    }

    public static class Compiler {
        public final boolean escapeHTML;
        public final boolean standardsMode;
        public final String nullValue;
        public final boolean missingIsNull;
        public final TemplateLoader loader;

        public Template compile(String template) {
            return this.compile(new StringReader(template));
        }

        public Template compile(Reader source) {
            return Mustache.compile(source, this);
        }

        public Compiler escapeHTML(boolean escapeHTML) {
            return new Compiler(escapeHTML, this.standardsMode, this.nullValue, this.missingIsNull, this.loader);
        }

        public Compiler standardsMode(boolean standardsMode) {
            return new Compiler(this.escapeHTML, standardsMode, this.nullValue, this.missingIsNull, this.loader);
        }

        public Compiler defaultValue(String defaultValue) {
            return new Compiler(this.escapeHTML, this.standardsMode, defaultValue, true, this.loader);
        }

        public Compiler nullValue(String nullValue) {
            return new Compiler(this.escapeHTML, this.standardsMode, nullValue, false, this.loader);
        }

        public Compiler withLoader(TemplateLoader loader) {
            return new Compiler(this.escapeHTML, this.standardsMode, this.nullValue, this.missingIsNull, loader);
        }

        protected Compiler(boolean escapeHTML, boolean standardsMode, String nullValue, boolean missingIsNull, TemplateLoader loader) {
            this.escapeHTML = escapeHTML;
            this.standardsMode = standardsMode;
            this.nullValue = nullValue;
            this.missingIsNull = missingIsNull;
            this.loader = loader;
        }
    }
}

