/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class IkvmMavenMojo
extends AbstractMojo {
    public File ikvmPath;
    public File monoPath;
    public List<String> ikvmArgs;
    public List<String> dlls;
    public List<String> copyDlls;
    public boolean createStub;
    public ArtifactRepository localRepository;
    private MavenProject _project;
    private ArtifactResolver _resolver;
    private ArtifactMetadataSource _metadataSource;
    private ArtifactFactory _factory;

    public void execute() throws MojoExecutionException {
        File projectDir = new File(this._project.getBuild().getDirectory());
        if (!projectDir.isDirectory()) {
            projectDir.mkdir();
        }
        File artifactFile = new File(projectDir, this._project.getBuild().getFinalName() + ".dll");
        this._project.getArtifact().setFile(artifactFile);
        if (this.ikvmPath == null) {
            if (this.createStub) {
                this.getLog().info((CharSequence)"ikvm.path is not set. Creating stub IKVM artifact.");
                try {
                    artifactFile.createNewFile();
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException("Unable to create stub artifact file: " + artifactFile, (Exception)ioe);
                }
            } else {
                this.getLog().warn((CharSequence)"ikvm.path is not set. Skipping IKVM build.");
            }
            return;
        }
        if (!this.monoPath.isDirectory()) {
            throw new MojoExecutionException("mono.path refers to non- or non-existent directory: " + this.monoPath);
        }
        if (!this.ikvmPath.isDirectory()) {
            throw new MojoExecutionException("ikvm.path refers to non- or non-existent directory: " + this.monoPath);
        }
        File ikvmc = new File(new File(this.ikvmPath, "bin"), "ikvmc.exe");
        if (!ikvmc.exists()) {
            throw new MojoExecutionException("Unable to find ikmvc at: " + ikvmc);
        }
        ArrayList<File> javaDepends = new ArrayList<File>();
        ArrayList<File> dllDepends = new ArrayList<File>();
        try {
            for (Object a : this._project.getArtifacts()) {
                Artifact artifact = (Artifact)a;
                this.getLog().debug((CharSequence)("Considering artifact [" + artifact.getGroupId() + ":" + artifact.getArtifactId() + "]"));
                if (artifact.getScope().equals("test")) continue;
                if ("dll".equals(artifact.getType())) {
                    dllDepends.add(artifact.getFile());
                    continue;
                }
                javaDepends.add(artifact.getFile());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve dependencies.", e);
        }
        Commandline cli = new Commandline("mono");
        File ikvmcExe = new File(new File(this.ikvmPath, "bin"), "ikvmc.exe");
        cli.createArgument().setValue(ikvmcExe.getAbsolutePath());
        ArrayList<String> stdArgs = new ArrayList<String>();
        stdArgs.add("-nostdlib");
        stdArgs.add("-target:library");
        for (String arg : stdArgs) {
            cli.createArgument().setValue(arg);
        }
        for (String arg : this.ikvmArgs) {
            if (stdArgs.contains(arg)) continue;
            if (arg.startsWith("-out:")) {
                this.getLog().warn((CharSequence)"Don't specify -out:file directly. Set project.build.directory and project.build.finalName in your POM.");
                continue;
            }
            cli.createArgument().setValue(arg);
        }
        cli.createArgument().setValue("-out:" + artifactFile.getAbsolutePath());
        cli.addEnvironment("MONO_PATH", this.monoPath.getAbsolutePath());
        ArrayList<String> stdDlls = new ArrayList<String>();
        stdDlls.add("mscorlib.dll");
        stdDlls.add("System.dll");
        stdDlls.add("System.Core.dll");
        for (String string : stdDlls) {
            cli.createArgument().setValue("-r:" + new File(this.monoPath, string).getAbsolutePath());
        }
        for (String string : this.dlls) {
            if (stdDlls.contains(string)) continue;
            if (new File(string).isAbsolute()) {
                cli.createArgument().setValue("-r:" + string);
                continue;
            }
            cli.createArgument().setValue("-r:" + new File(this.monoPath, string).getAbsolutePath());
        }
        for (File file : dllDepends) {
            cli.createArgument().setValue("-r:" + file.getAbsolutePath());
        }
        for (File file : javaDepends) {
            cli.createArgument().setValue(file.getAbsolutePath());
        }
        for (String string : this.copyDlls) {
            File dfile = new File(string);
            if (!dfile.exists()) {
                dfile = new File(this.ikvmPath, string);
            }
            if (!dfile.exists()) {
                throw new MojoExecutionException(string + " does not exist (nor does " + dfile.getPath() + ")");
            }
            try {
                FileUtils.copyFile((File)dfile, (File)new File(projectDir, dfile.getName()));
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to copy " + dfile + " into " + projectDir, (Exception)ioe);
            }
        }
        this.getLog().debug((CharSequence)("CMD: " + cli));
        CommandLineUtils.StringStreamConsumer stdoutC = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stringStreamConsumer = new CommandLineUtils.StringStreamConsumer();
        try {
            String stderr;
            int rv = CommandLineUtils.executeCommandLine((Commandline)cli, null, (StreamConsumer)stdoutC, (StreamConsumer)stringStreamConsumer);
            String stdout = stdoutC.getOutput();
            if (stdout != null && stdout.length() > 0) {
                this.getLog().info((CharSequence)stdout);
            }
            if ((stderr = stringStreamConsumer.getOutput()) != null && stderr.length() > 0) {
                this.getLog().warn((CharSequence)stderr);
            }
            if (rv != 0) {
                throw new MojoExecutionException("ikvmc.exe failed; see above output.");
            }
        }
        catch (CommandLineException clie) {
            throw new MojoExecutionException("Executing ikvmc.exe failed", (Exception)((Object)clie));
        }
    }
}

