/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.base.Preconditions;
import com.samskivert.depot.Log;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.FullTextIndex;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.impl.BuildVisitor;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.FieldMarshaller;
import com.samskivert.jdbc.ColumnDefinition;
import com.samskivert.util.ByteEnum;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;

public abstract class SQLBuilder {
    protected DepotTypes _types;
    protected QueryClause _clause;
    protected BuildVisitor _buildVisitor;

    public SQLBuilder(DepotTypes types) {
        this._types = types;
    }

    public boolean newQuery(QueryClause clause) {
        this._clause = clause;
        this._buildVisitor = this.getBuildVisitor();
        this._clause.accept(this._buildVisitor);
        return this._buildVisitor.getQuery().trim().length() > 0;
    }

    public PreparedStatement prepare(Connection conn) throws SQLException {
        Preconditions.checkState((this._buildVisitor != null ? 1 : 0) != 0, (Object)"Cannot prepare query until it's been built.");
        PreparedStatement stmt = conn.prepareStatement(this._buildVisitor.getQuery());
        int argIx = 1;
        for (BuildVisitor.Bindable bindable : this._buildVisitor.getBindables()) {
            try {
                bindable.doBind(conn, stmt, argIx);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to bind statement argument", new Object[]{"argIx", argIx, e});
            }
            ++argIx;
        }
        if (PersistenceContext.DEBUG) {
            Log.log.info((Object)("SQL: " + stmt.toString()), new Object[0]);
        }
        return stmt;
    }

    protected String nullify(String str) {
        return str != null && str.length() > 0 ? str : null;
    }

    public ColumnDefinition buildColumnDefinition(FieldMarshaller<?> fm) {
        if (fm.getComputed() != null) {
            return null;
        }
        Field field = fm.getField();
        Column column = field.getAnnotation(Column.class);
        ColumnDefinition coldef = column != null ? new ColumnDefinition(null, column.nullable(), column.unique(), this.nullify(column.defaultValue())) : new ColumnDefinition();
        GeneratedValue genValue = fm.getGeneratedValue();
        if (genValue != null) {
            this.maybeMutateForGeneratedValue(field, genValue, coldef);
        } else if (coldef.defaultValue == null) {
            this.maybeMutateForPrimitive(field, coldef);
        }
        if (coldef.type == null) {
            coldef.type = this.getColumnType(fm, column != null ? column.length() : 255);
        }
        Preconditions.checkArgument((!coldef.nullable || !field.getType().isPrimitive() ? 1 : 0) != 0, (Object)("Primitive Java type cannot be nullable [field=" + field.getName() + "]"));
        return coldef;
    }

    protected void maybeMutateForPrimitive(Field field, ColumnDefinition coldef) {
        if (field.getType().equals(Byte.TYPE) || field.getType().equals(Short.TYPE) || field.getType().equals(Integer.TYPE) || field.getType().equals(Long.TYPE) || field.getType().equals(Float.TYPE) || field.getType().equals(Double.TYPE) || ByteEnum.class.isAssignableFrom(field.getType())) {
            coldef.defaultValue = "0";
        } else if (field.getType().equals(Boolean.TYPE)) {
            coldef.defaultValue = this.getBooleanDefault();
        }
    }

    protected void maybeMutateForGeneratedValue(Field field, GeneratedValue genValue, ColumnDefinition coldef) {
        switch (genValue.strategy()) {
            case AUTO: 
            case IDENTITY: {
                coldef.type = this.getSerialType(field);
                coldef.unique = true;
                break;
            }
            case SEQUENCE: {
                throw new IllegalArgumentException("SEQUENCE key generation strategy not yet supported.");
            }
        }
    }

    protected String getSerialType(Field field) {
        return "SERIAL";
    }

    protected String getBooleanDefault() {
        return "false";
    }

    public abstract <T extends PersistentRecord> boolean addFullTextSearch(Connection var1, DepotMarshaller<T> var2, FullTextIndex var3) throws SQLException;

    public abstract boolean isPrivateColumn(String var1, Map<String, FullTextIndex> var2);

    public abstract boolean isPrivateIndex(String var1, Map<String, FullTextIndex> var2);

    public abstract void getFtsIndexes(Iterable<String> var1, Iterable<String> var2, Set<String> var3);

    protected abstract BuildVisitor getBuildVisitor();

    protected abstract <T> String getColumnType(FieldMarshaller<?> var1, int var2);
}

