/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.depot.CacheAdapter;
import com.samskivert.depot.CacheKey;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.Log;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.Stats;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.SelectClause;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.Fetcher;
import com.samskivert.depot.impl.KeyCacheKey;
import com.samskivert.depot.impl.QueryResult;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.jdbc.DatabaseLiaison;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FindOneQuery<T extends PersistentRecord>
extends Fetcher<T> {
    protected DepotRepository.CacheStrategy _strategy;
    protected DepotMarshaller<T> _marsh;
    protected SelectClause _select;
    protected SQLBuilder _builder;
    protected int _cachedRecords;

    public FindOneQuery(PersistenceContext ctx, Class<T> type, DepotRepository.CacheStrategy strategy, QueryClause[] clauses) throws DatabaseException {
        this._strategy = strategy;
        this._marsh = ctx.getMarshaller(type);
        this._select = new SelectClause(type, this._marsh.getSelections(), clauses);
        WhereClause where = this._select.getWhereClause();
        if (where != null) {
            this._select.getWhereClause().validateQueryType(type);
        }
        this._builder = ctx.getSQLBuilder(DepotTypes.getDepotTypes(ctx, this._select));
        this._builder.newQuery(this._select);
    }

    @Override
    public T getCachedResult(PersistenceContext ctx) {
        CacheKey key = this.getCacheKey();
        if (key == null) {
            return null;
        }
        PersistentRecord value = (PersistentRecord)ctx.cacheLookup(key);
        if (value == null) {
            return null;
        }
        this._cachedRecords = 1;
        PersistentRecord cvalue = (PersistentRecord)value.clone();
        return (T)cvalue;
    }

    @Override
    public T invoke(PersistenceContext ctx, Connection conn, DatabaseLiaison liaison) throws SQLException {
        Object result = null;
        ResultSet rs = this._builder.prepare(conn).executeQuery();
        if (rs.next()) {
            result = this._marsh.createObject(rs);
        }
        rs.close();
        CacheKey key = this.getCacheKey();
        if (key == null && result != null && this._marsh.hasPrimaryKey()) {
            key = new KeyCacheKey(this._marsh.getPrimaryKey(result));
        }
        if (PersistenceContext.CACHE_DEBUG) {
            Log.log.info((Object)("Loaded " + (key != null ? key : this._marsh.getTableName())), new Object[0]);
        }
        if (key != null) {
            ctx.cacheStore(CacheAdapter.CacheCategory.RECORD, key, result != null ? ((QueryResult)result).clone() : null);
            if (PersistenceContext.CACHE_DEBUG) {
                Log.log.info((Object)("Cached " + key), new Object[0]);
            }
        }
        return (T)result;
    }

    @Override
    public void updateStats(Stats stats) {
        stats.noteQuery(this._marsh.getPersistentClass(), 0, 0, 0, this._cachedRecords, 1 - this._cachedRecords);
    }

    protected CacheKey getCacheKey() {
        if (this._strategy == DepotRepository.CacheStrategy.NONE) {
            return null;
        }
        WhereClause where = this._select.getWhereClause();
        return where != null && where instanceof CacheKey ? (CacheKey)((Object)where) : null;
    }
}

