/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.Log;
import com.samskivert.depot.Exps;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.FullTextIndex;
import com.samskivert.depot.impl.BuildVisitor;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.FieldMarshaller;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.depot.impl.expression.DateFun;
import com.samskivert.depot.impl.expression.IntervalExp;
import com.samskivert.depot.operator.FullText;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.LiaisonRegistry;
import com.samskivert.util.StringUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;

public class PostgreSQLBuilder
extends SQLBuilder {
    public static final boolean PG83 = Boolean.getBoolean("com.samskivert.depot.pg83");
    protected static final FieldMarshaller.ColumnTyper TYPER = new FieldMarshaller.ColumnTyper(){

        @Override
        public String getBooleanType(int length) {
            return "BOOLEAN";
        }

        @Override
        public String getByteType(int length) {
            return "SMALLINT";
        }

        @Override
        public String getShortType(int length) {
            return "SMALLINT";
        }

        @Override
        public String getIntType(int length) {
            return "INTEGER";
        }

        @Override
        public String getLongType(int length) {
            return "BIGINT";
        }

        @Override
        public String getFloatType(int length) {
            return "REAL";
        }

        @Override
        public String getDoubleType(int length) {
            return "DOUBLE PRECISION";
        }

        @Override
        public String getStringType(int length) {
            return "VARCHAR(" + length + ")";
        }

        @Override
        public String getDateType(int length) {
            return "DATE";
        }

        @Override
        public String getTimeType(int length) {
            return "TIME";
        }

        @Override
        public String getTimestampType(int length) {
            return "TIMESTAMP";
        }

        @Override
        public String getBlobType(int length) {
            return "BYTEA";
        }

        @Override
        public String getClobType(int length) {
            return "TEXT";
        }
    };

    public PostgreSQLBuilder(DepotTypes types) {
        super(types);
    }

    @Override
    public void getFtsIndexes(Iterable<String> columns, Iterable<String> indexes, Set<String> target) {
        for (String column : columns) {
            if (!column.startsWith("ftsCol_")) continue;
            target.add(column.substring("ftsCol_".length()));
        }
    }

    @Override
    public <T extends PersistentRecord> boolean addFullTextSearch(Connection conn, DepotMarshaller<T> marshaller, FullTextIndex fts) throws SQLException {
        Class<T> pClass = marshaller.getPersistentClass();
        DatabaseLiaison liaison = LiaisonRegistry.getLiaison((Connection)conn);
        String[] fields = fts.fields();
        String table = marshaller.getTableName();
        String column = "ftsCol_" + fts.name();
        String index = table + "_ftsIx_" + fts.name();
        String trigger = table + "_ftsTrig_" + fts.name();
        StringBuilder initColumn = new StringBuilder("UPDATE ").append(liaison.tableSQL(table)).append(" SET ").append(liaison.columnSQL(column)).append(" = TO_TSVECTOR('").append(PostgreSQLBuilder.translateFTConfig(fts.configuration())).append("', ");
        for (int ii = 0; ii < fields.length; ++ii) {
            if (ii > 0) {
                initColumn.append(" || ' ' || ");
            }
            initColumn.append("COALESCE(").append(liaison.columnSQL(this._types.getColumnName(pClass, fields[ii]))).append(", '')");
        }
        initColumn.append(")");
        String triggerFun = PG83 ? "tsvector_update_trigger" : "tsearch2";
        StringBuilder createTrigger = new StringBuilder("CREATE TRIGGER ").append(liaison.columnSQL(trigger)).append(" BEFORE UPDATE OR INSERT ON ").append(liaison.tableSQL(table)).append(" FOR EACH ROW EXECUTE PROCEDURE ").append(triggerFun).append("(").append(liaison.columnSQL(column)).append(", ");
        if (PG83) {
            createTrigger.append("'").append(PostgreSQLBuilder.translateFTConfig(fts.configuration())).append("', ");
        }
        for (int ii = 0; ii < fields.length; ++ii) {
            if (ii > 0) {
                createTrigger.append(", ");
            }
            createTrigger.append(liaison.columnSQL(this._types.getColumnName(pClass, fields[ii])));
        }
        createTrigger.append(")");
        StringBuilder createIndex = new StringBuilder("CREATE INDEX ").append(liaison.columnSQL(index)).append(" ON ").append(liaison.tableSQL(table)).append(" USING ").append(PG83 ? "GIN" : "GIST").append("(").append(liaison.columnSQL(column)).append(")");
        Statement stmt = conn.createStatement();
        Log.log.info((Object)("Adding full-text search column, index and trigger: " + column + ", " + index + ", " + trigger), new Object[0]);
        liaison.addColumn(conn, table, column, "TSVECTOR", true);
        stmt.executeUpdate(initColumn.toString());
        stmt.executeUpdate(createIndex.toString());
        stmt.executeUpdate(createTrigger.toString());
        return true;
    }

    @Override
    public boolean isPrivateColumn(String column, Map<String, FullTextIndex> fullTextIndexes) {
        for (FullTextIndex fti : fullTextIndexes.values()) {
            if (!("ftsCol_" + fti.name()).equals(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPrivateIndex(String index, Map<String, FullTextIndex> fullTextIndexes) {
        if (index.endsWith("_key") || index.endsWith("_pkey")) {
            return true;
        }
        for (FullTextIndex fti : fullTextIndexes.values()) {
            if (!index.endsWith("_ftsIx_" + fti.name())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected BuildVisitor getBuildVisitor() {
        return new PGBuildVisitor(this._types);
    }

    @Override
    protected <T> String getColumnType(FieldMarshaller<?> fm, int length) {
        return fm.getColumnType(TYPER, length);
    }

    @Override
    protected String getSerialType(Field field) {
        return field.getType().equals(Long.TYPE) ? "BIGSERIAL" : "SERIAL";
    }

    protected static String massageFTQuery(FullText fullText) {
        Object[] searchTerms = fullText.getQuery().toLowerCase().trim().split("\\W+");
        String operator = fullText.isMatchAll() ? "&" : "|";
        return StringUtil.join((Object[])searchTerms, (String)operator);
    }

    protected static String translateFTConfig(FullTextIndex.Configuration configuration) {
        if (!PG83) {
            return "default";
        }
        switch (configuration) {
            case Simple: {
                return "pg_catalog.simple";
            }
            case English: {
                return "pg_catalog.english";
            }
        }
        throw new IllegalArgumentException("Unknown full text configuration: " + (Object)((Object)configuration));
    }

    public class PGBuildVisitor
    extends BuildVisitor {
        @Override
        public Void visit(IntervalExp interval) {
            this._builder.append("interval '").append(interval.amount);
            this._builder.append(" ").append((Object)interval.unit).append("'");
            return null;
        }

        @Override
        public Void visit(FullText.Match match) {
            this.appendIdentifier("ftsCol_" + match.getDefinition().getName());
            this._builder.append(" @@ to_tsquery('").append(PostgreSQLBuilder.translateFTConfig(this.getFTIndex(match.getDefinition()).configuration())).append("', ");
            this.bindValue(PostgreSQLBuilder.massageFTQuery(match.getDefinition()));
            this._builder.append(")");
            return null;
        }

        @Override
        public Void visit(FullText.Rank rank) {
            this._builder.append(PG83 ? "ts_rank" : "rank").append("(");
            this.appendIdentifier("ftsCol_" + rank.getDefinition().getName());
            this._builder.append(", to_tsquery('").append(PostgreSQLBuilder.translateFTConfig(this.getFTIndex(rank.getDefinition()).configuration())).append("', ");
            this.bindValue(PostgreSQLBuilder.massageFTQuery(rank.getDefinition()));
            this._builder.append("), 1)");
            return null;
        }

        @Override
        public Void visit(DateFun.DatePart exp) {
            String datePart = "'" + this.translateDatePart(exp.getPart()) + "'";
            return this.appendFunctionCall("date_part", Exps.literal(datePart), exp.getArg());
        }

        @Override
        public Void visit(DateFun.DateTruncate exp) {
            String field = "'" + exp.getTruncation().toString().toLowerCase() + "'";
            return this.appendFunctionCall("date_trunc", Exps.literal(field), exp.getArg());
        }

        protected String translateDatePart(DateFun.DatePart.Part part) {
            switch (part) {
                case DAY_OF_MONTH: {
                    return "day";
                }
                case DAY_OF_WEEK: {
                    return "dow";
                }
                case DAY_OF_YEAR: {
                    return "doy";
                }
                case HOUR: {
                    return "hour";
                }
                case MINUTE: {
                    return "minute";
                }
                case MONTH: {
                    return "month";
                }
                case SECOND: {
                    return "second";
                }
                case WEEK: {
                    return "week";
                }
                case YEAR: {
                    return "year";
                }
                case EPOCH: {
                    return "epoch";
                }
            }
            throw new IllegalArgumentException("Unknown date part: " + (Object)((Object)part));
        }

        protected FullTextIndex getFTIndex(FullText definition) {
            DepotMarshaller<? extends PersistentRecord> marsh = this._types.getMarshaller(definition.getPersistentClass());
            return marsh.getFullTextIndex(definition.getName());
        }

        @Override
        protected void appendIdentifier(String field) {
            this._builder.append("\"").append(field).append("\"");
        }

        protected PGBuildVisitor(DepotTypes types) {
            super(types, true);
        }
    }
}

