/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.collect.Lists;
import com.samskivert.depot.Exps;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.FullTextIndex;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.BuildVisitor;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.FieldMarshaller;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.depot.impl.expression.AggregateFun;
import com.samskivert.depot.impl.expression.DateFun;
import com.samskivert.depot.impl.expression.LiteralExp;
import com.samskivert.depot.impl.expression.NumericalFun;
import com.samskivert.depot.impl.expression.StringFun;
import com.samskivert.depot.impl.expression.ValueExp;
import com.samskivert.depot.impl.operator.BitAnd;
import com.samskivert.depot.impl.operator.BitOr;
import com.samskivert.depot.impl.operator.Like;
import com.samskivert.depot.impl.operator.MultiOperator;
import com.samskivert.depot.operator.FullText;
import com.samskivert.jdbc.ColumnDefinition;
import com.samskivert.util.ArrayUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class HSQLBuilder
extends SQLBuilder {
    protected SQLExpression<?> _ftsCondition;
    protected static final FieldMarshaller.ColumnTyper TYPER = new FieldMarshaller.ColumnTyper(){

        @Override
        public String getBooleanType(int length) {
            return "BOOLEAN";
        }

        @Override
        public String getByteType(int length) {
            return "TINYINT";
        }

        @Override
        public String getShortType(int length) {
            return "SMALLINT";
        }

        @Override
        public String getIntType(int length) {
            return "INTEGER";
        }

        @Override
        public String getLongType(int length) {
            return "BIGINT";
        }

        @Override
        public String getFloatType(int length) {
            return "REAL";
        }

        @Override
        public String getDoubleType(int length) {
            return "DOUBLE PRECISION";
        }

        @Override
        public String getStringType(int length) {
            return "VARCHAR(" + length + ")";
        }

        @Override
        public String getDateType(int length) {
            return "DATE";
        }

        @Override
        public String getTimeType(int length) {
            return "TIME";
        }

        @Override
        public String getTimestampType(int length) {
            return "TIMESTAMP";
        }

        @Override
        public String getBlobType(int length) {
            return "VARBINARY(" + length + ")";
        }

        @Override
        public String getClobType(int length) {
            return "VARCHAR";
        }
    };

    public HSQLBuilder(DepotTypes types) {
        super(types);
    }

    @Override
    public void getFtsIndexes(Iterable<String> columns, Iterable<String> indexes, Set<String> target) {
    }

    @Override
    public <T extends PersistentRecord> boolean addFullTextSearch(Connection conn, DepotMarshaller<T> marshaller, FullTextIndex fts) throws SQLException {
        return true;
    }

    @Override
    public boolean isPrivateColumn(String column, Map<String, FullTextIndex> fullTextIndexes) {
        return false;
    }

    @Override
    public boolean isPrivateIndex(String index, Map<String, FullTextIndex> fullTextIndexes) {
        return index.startsWith("SYS_IDX");
    }

    @Override
    protected String getBooleanDefault() {
        return "false";
    }

    @Override
    protected BuildVisitor getBuildVisitor() {
        return new HBuildVisitor(this._types);
    }

    @Override
    protected void maybeMutateForGeneratedValue(Field field, GeneratedValue genValue, ColumnDefinition column) {
        switch (genValue.strategy()) {
            case AUTO: 
            case IDENTITY: {
                column.defaultValue = "IDENTITY";
                column.unique = true;
                break;
            }
            default: {
                super.maybeMutateForGeneratedValue(field, genValue, column);
            }
        }
    }

    @Override
    protected <T> String getColumnType(FieldMarshaller<?> fm, int length) {
        return fm.getColumnType(TYPER, length);
    }

    public class HBuildVisitor
    extends BuildVisitor {
        @Override
        public Void visit(AggregateFun.Average<?> exp) {
            return this.appendAggregateFunctionCall("avg", exp);
        }

        @Override
        public Void visit(NumericalFun.Round<?> exp) {
            return this.appendFunctionCall("round", exp.getArg(), Exps.value(0));
        }

        @Override
        public Void visit(NumericalFun.Trunc<?> exp) {
            return this.appendFunctionCall("truncate", exp.getArg(), Exps.value(0));
        }

        @Override
        public Void visit(NumericalFun.Random<?> exp) {
            return this.appendFunctionCall("rand", new SQLExpression[0]);
        }

        @Override
        public Void visit(NumericalFun.Power<?> exp) {
            SQLExpression<?> power = exp.getPower();
            if (power instanceof ValueExp) {
                power = new LiteralExp(((ValueExp)power).getValue().toString());
            }
            return this.appendFunctionCall("power", exp.getValue(), power);
        }

        @Override
        public Void visit(FullText.Match match) {
            Class<? extends PersistentRecord> pClass = match.getDefinition().getPersistentClass();
            String[] fields = this._types.getMarshaller(pClass).getFullTextIndex(match.getDefinition().getName()).fields();
            Object[] ftsWords = match.getDefinition().getQuery().toLowerCase().split("\\W+");
            if (ftsWords.length > 0 && ftsWords[0].length() == 0) {
                ftsWords = (String[])ArrayUtil.splice((Object[])ftsWords, (int)0, (int)1);
            }
            ArrayList bits = Lists.newArrayList();
            for (String field : fields) {
                for (Object ftsWord : ftsWords) {
                    bits.add(new Like((SQLExpression<?>)new StringFun.Lower((SQLExpression<String>)new ColumnExp<String>(pClass, field)), (Comparable<?>)((Object)("%" + (String)ftsWord + "%")), true));
                }
            }
            HSQLBuilder.this._ftsCondition = Ops.or(bits);
            HSQLBuilder.this._ftsCondition.accept(this);
            return null;
        }

        @Override
        public Void visit(FullText.Rank rank) {
            this._builder.append("0");
            return null;
        }

        @Override
        public Void visit(MultiOperator<?> operator) {
            if (operator instanceof BitAnd) {
                return this.appendFunctionCall("bitand", operator.getArgs());
            }
            if (operator instanceof BitOr) {
                return this.appendFunctionCall("bitor", operator.getArgs());
            }
            return super.visit((MultiOperator)operator);
        }

        @Override
        public Void visit(DateFun.DatePart exp) {
            if (exp.getPart() == DateFun.DatePart.Part.EPOCH) {
                this._builder.append("datediff('ss', ");
                exp.getArg().accept(this);
                this._builder.append(", '1970-01-01')");
                return null;
            }
            return this.appendFunctionCall(this.getDateFunction(exp.getPart()), exp.getArg());
        }

        @Override
        public Void visit(DateFun.DateTruncate exp) {
            throw new IllegalArgumentException("HSQL does not have built-in date truncation");
        }

        protected HBuildVisitor(DepotTypes types) {
            super(types, false);
        }

        protected String getDateFunction(DateFun.DatePart.Part part) {
            switch (part) {
                case DAY_OF_MONTH: {
                    return "dayofmonth";
                }
                case DAY_OF_WEEK: {
                    return "dayofweek";
                }
                case DAY_OF_YEAR: {
                    return "dayofyear";
                }
                case HOUR: {
                    return "hour";
                }
                case MINUTE: {
                    return "minute";
                }
                case MONTH: {
                    return "month";
                }
                case SECOND: {
                    return "second";
                }
                case WEEK: {
                    return "week";
                }
                case YEAR: {
                    return "year";
                }
            }
            throw new IllegalArgumentException("Unknown date part: " + (Object)((Object)part));
        }

        @Override
        protected void appendIdentifier(String field) {
            this._builder.append("\"").append(field).append("\"");
        }
    }
}

