/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.depot.Key;
import com.samskivert.depot.Log;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.FieldDefinition;
import com.samskivert.depot.clause.ForUpdate;
import com.samskivert.depot.clause.FromOverride;
import com.samskivert.depot.clause.GroupBy;
import com.samskivert.depot.clause.InsertClause;
import com.samskivert.depot.clause.Join;
import com.samskivert.depot.clause.Limit;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.SelectClause;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.DepotUtil;
import com.samskivert.depot.impl.FragmentVisitor;
import com.samskivert.depot.impl.clause.CreateIndexClause;
import com.samskivert.depot.impl.clause.DeleteClause;
import com.samskivert.depot.impl.clause.DropIndexClause;
import com.samskivert.depot.impl.clause.UpdateClause;
import com.samskivert.depot.impl.expression.AggregateFun;
import com.samskivert.depot.impl.expression.ConditionalFun;
import com.samskivert.depot.impl.expression.DateFun;
import com.samskivert.depot.impl.expression.IntervalExp;
import com.samskivert.depot.impl.expression.LiteralExp;
import com.samskivert.depot.impl.expression.NumericalFun;
import com.samskivert.depot.impl.expression.StringFun;
import com.samskivert.depot.impl.expression.ValueExp;
import com.samskivert.depot.impl.operator.BinaryOperator;
import com.samskivert.depot.impl.operator.Exists;
import com.samskivert.depot.impl.operator.In;
import com.samskivert.depot.impl.operator.IsNull;
import com.samskivert.depot.impl.operator.MultiOperator;
import com.samskivert.depot.impl.operator.Not;
import com.samskivert.depot.operator.Case;
import com.samskivert.depot.operator.FullText;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.Tuple;
import java.lang.reflect.Field;

public class ExpressionEvaluator
implements FragmentVisitor<Object> {
    protected Class<? extends PersistentRecord> _pClass;
    protected PersistentRecord _pRec;

    public <T extends PersistentRecord> ExpressionEvaluator(Class<T> pClass, T pRec) {
        this._pClass = pClass;
        this._pRec = pRec;
    }

    @Override
    public Object visit(MultiOperator<?> multiOperator) {
        SQLExpression<?>[] operands = multiOperator.getArgs();
        Object[] values = new Object[operands.length];
        for (int ii = 0; ii < operands.length; ++ii) {
            values[ii] = operands[ii].accept(this);
            if (!(values[ii] instanceof SQLExpression.NoValue)) continue;
            return values[ii];
        }
        return multiOperator.evaluate(values);
    }

    @Override
    public Object visit(BinaryOperator<?> binaryOperator) {
        Object left = binaryOperator.getLeftHandSide().accept(this);
        Object right = binaryOperator.getRightHandSide().accept(this);
        if (left instanceof SQLExpression.NoValue) {
            return left;
        }
        if (right instanceof SQLExpression.NoValue) {
            return right;
        }
        return binaryOperator.evaluate(left, right);
    }

    @Override
    public Object visit(IsNull isNull) {
        Object operand = isNull.getExpression().accept(this);
        return operand instanceof SQLExpression.NoValue ? operand : Boolean.valueOf(operand != null);
    }

    @Override
    public Object visit(In in) {
        Object operand = in.getExpression().accept(this);
        return operand instanceof SQLExpression.NoValue ? operand : Boolean.valueOf(-1 != ArrayUtil.indexOf((Object[])in.getValues(), (Object)operand));
    }

    @Override
    public Object visit(FullText.Match match) {
        return new SQLExpression.NoValue("Full Text Match not implemented");
    }

    @Override
    public Object visit(FullText.Rank rank) {
        return new SQLExpression.NoValue("Full Text Match not implemented");
    }

    @Override
    public Object visit(Case<?> caseExp) {
        for (Tuple<SQLExpression<?>, SQLExpression<?>> exp : caseExp.getWhenExps()) {
            Object result = ((SQLExpression)exp.left).accept(this);
            if (result instanceof SQLExpression.NoValue || !(result instanceof Boolean)) {
                return new SQLExpression.NoValue("Failed to evaluate case: " + exp.left + " -> " + result);
            }
            if (!((Boolean)result).booleanValue()) continue;
            return ((SQLExpression)exp.right).accept(this);
        }
        SQLExpression<?> elseExp = caseExp.getElseExp();
        if (elseExp != null) {
            return elseExp.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(ColumnExp<?> columnExp) {
        Class<PersistentRecord> pClass = columnExp.getPersistentClass();
        if (pClass != this._pClass) {
            return new SQLExpression.NoValue("Column lookup on unknown persistent class: " + pClass);
        }
        try {
            Field field = pClass.getField(columnExp.name);
            if (field == null) {
                Log.log.warning((Object)"Couldn't locate field on class", new Object[]{"field", columnExp.name, "class", pClass});
                return new SQLExpression.NoValue("Internal Error");
            }
            return field.get(this._pRec);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to retrieve field value", new Object[]{"field", columnExp.name, e});
            return new SQLExpression.NoValue("Internal Error");
        }
    }

    @Override
    public Object visit(Not not) {
        Object result = not.getCondition().accept(this);
        if (result instanceof SQLExpression.NoValue) {
            return result;
        }
        if (result instanceof Boolean) {
            return (Boolean)result == false;
        }
        return new SQLExpression.NoValue("Boolean negation of non-boolean value: " + result);
    }

    @Override
    public Object visit(LiteralExp<?> literalExp) {
        return new SQLExpression.NoValue("Cannot evaluate LiteralExp: " + literalExp);
    }

    @Override
    public Object visit(ValueExp<?> valueExp) {
        return valueExp.getValue();
    }

    @Override
    public Object visit(IntervalExp interval) {
        return new SQLExpression.NoValue("Cannot evaluate IntervalExp: " + interval);
    }

    @Override
    public Object visit(WhereClause where) {
        Object result = where.getWhereExpression().accept(this);
        if (result instanceof SQLExpression.NoValue || result instanceof Boolean) {
            return result;
        }
        return new SQLExpression.NoValue("Non-boolean result from Where expression: " + result);
    }

    @Override
    public Object visit(Key.Expression key) {
        Class<? extends PersistentRecord> pClass = key.getPersistentClass();
        if (pClass != this._pClass) {
            return new SQLExpression.NoValue("Column lookup on unknown persistent class: " + pClass);
        }
        ColumnExp<?>[] keyFields = DepotUtil.getKeyFields(pClass);
        Comparable<?>[] values = key.getValues();
        for (int ii = 0; ii < keyFields.length; ++ii) {
            Object value;
            try {
                value = pClass.getDeclaredField(keyFields[ii].name).get(this._pRec);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to retrieve field value", new Object[]{"field", keyFields[ii], e});
                return new SQLExpression.NoValue("Internal Error");
            }
            if (!(value == null ? values[ii] != null : !value.equals(values[ii]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object visit(Exists exists) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exists);
    }

    @Override
    public Object visit(GroupBy groupBy) {
        throw new IllegalArgumentException("Can't evaluate expression: " + groupBy);
    }

    @Override
    public Object visit(ForUpdate forUpdate) {
        throw new IllegalArgumentException("Can't evaluate expression: " + forUpdate);
    }

    @Override
    public Object visit(OrderBy orderBy) {
        throw new IllegalArgumentException("Can't evaluate expression: " + orderBy);
    }

    @Override
    public Object visit(Join join) {
        throw new IllegalArgumentException("Can't evaluate expression: " + join);
    }

    @Override
    public Object visit(Limit limit) {
        throw new IllegalArgumentException("Can't evaluate expression: " + limit);
    }

    @Override
    public Object visit(FieldDefinition fieldOverride) {
        throw new IllegalArgumentException("Can't evaluate expression: " + fieldOverride);
    }

    @Override
    public Object visit(FromOverride fromOverride) {
        throw new IllegalArgumentException("Can't evaluate expression: " + fromOverride);
    }

    @Override
    public Object visit(SelectClause selectClause) {
        throw new IllegalArgumentException("Can't evaluate expression: " + selectClause);
    }

    @Override
    public Object visit(UpdateClause updateClause) {
        throw new IllegalArgumentException("Can't evaluate expression: " + updateClause);
    }

    @Override
    public Object visit(DeleteClause deleteClause) {
        throw new IllegalArgumentException("Can't evaluate expression: " + deleteClause);
    }

    @Override
    public Object visit(InsertClause insertClause) {
        throw new IllegalArgumentException("Can't evaluate expression: " + insertClause);
    }

    @Override
    public Object visit(CreateIndexClause createIndexClause) {
        throw new IllegalArgumentException("Can't evaluate expression: " + createIndexClause);
    }

    @Override
    public Object visit(DropIndexClause dropIndexClause) {
        throw new IllegalArgumentException("Can't evaluate expression: " + dropIndexClause);
    }

    @Override
    public Void visit(NumericalFun.Abs<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Ceil<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Exp<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Floor<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Ln<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Log10<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Pi<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Power<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Random<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Round<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Sign<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Sqrt<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(NumericalFun.Trunc<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(StringFun.Length exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(StringFun.Lower exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(StringFun.Position exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(StringFun.Substring exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(StringFun.Trim exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(StringFun.Upper exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(DateFun.DatePart exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(DateFun.DateTruncate exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(DateFun.Now exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(AggregateFun.Average<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(AggregateFun.Count exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(AggregateFun.Every exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(AggregateFun.Max<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(AggregateFun.Min<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(AggregateFun.Sum<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(ConditionalFun.Coalesce<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(ConditionalFun.Greatest<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    @Override
    public Void visit(ConditionalFun.Least<?> exp) {
        throw new IllegalArgumentException("Can't evaluate expression: " + exp);
    }

    public static Double numerical(Object o) {
        return o instanceof Number ? Double.valueOf(((Number)o).doubleValue()) : null;
    }

    public static Long integral(Object o) {
        return o instanceof Integer || o instanceof Long ? Long.valueOf(((Number)o).longValue()) : null;
    }
}

