/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.expression.ColumnExp;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;

public class DepotUtil {
    protected static ConcurrentMap<Class<? extends PersistentRecord>, ColumnExp<?>[]> _keyFields = new MapMaker().makeComputingMap((Function)new Function<Class<? extends PersistentRecord>, ColumnExp<?>[]>(){

        public ColumnExp<?>[] apply(Class<? extends PersistentRecord> pClass) {
            ArrayList kflist = Lists.newArrayList();
            for (Field field : pClass.getFields()) {
                if (field.getAnnotation(Id.class) == null) continue;
                kflist.add(new ColumnExp(pClass, field.getName()));
            }
            return kflist.toArray(new ColumnExp[kflist.size()]);
        }
    });

    public static ColumnExp<?>[] getKeyFields(Class<? extends PersistentRecord> pClass) {
        return (ColumnExp[])_keyFields.get(pClass);
    }

    public static void registerKeyFields(ColumnExp<?> ... fields) {
        _keyFields.putIfAbsent(fields[0].getPersistentClass(), fields);
    }

    public static String justClassName(Class<?> clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
    }
}

