/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.collect.Maps;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.HSQLBuilder;
import com.samskivert.depot.impl.Modifier;
import com.samskivert.depot.impl.MySQLBuilder;
import com.samskivert.depot.impl.PostgreSQL4Builder;
import com.samskivert.depot.impl.PostgreSQLBuilder;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.jdbc.ColumnDefinition;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.HsqldbLiaison;
import com.samskivert.jdbc.MySQLLiaison;
import com.samskivert.jdbc.PostgreSQLLiaison;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class DepotMetaData {
    protected PersistenceContext _ctx;
    protected int _jdbcMajorVersion;
    protected Map<String, Integer> _curvers = Maps.newHashMap();
    protected static final String SCHEMA_VERSION_TABLE = "DepotSchemaVersion";
    protected static final String P_COLUMN = "persistentClass";
    protected static final String V_COLUMN = "version";
    protected static final String MV_COLUMN = "migratingVersion";

    public void init(PersistenceContext ctx) {
        this._ctx = ctx;
        this._ctx.invoke(new SimpleModifier(){

            @Override
            protected int invoke(DatabaseLiaison liaison, Statement stmt) throws SQLException {
                DepotMetaData.this._jdbcMajorVersion = stmt.getConnection().getMetaData().getJDBCMajorVersion();
                liaison.createTableIfMissing(stmt.getConnection(), DepotMetaData.SCHEMA_VERSION_TABLE, new String[]{DepotMetaData.P_COLUMN, DepotMetaData.V_COLUMN, DepotMetaData.MV_COLUMN}, new ColumnDefinition[]{new ColumnDefinition("VARCHAR(255)", false, true, null), new ColumnDefinition("INTEGER", false, false, null), new ColumnDefinition("INTEGER", false, false, null)}, (String[][])null, new String[]{DepotMetaData.P_COLUMN});
                DepotMetaData.this.readVersions(liaison, stmt);
                return 0;
            }
        });
    }

    public int getVersion(String pClass, boolean forceUpdate) {
        Integer curvers;
        if (forceUpdate) {
            this._ctx.invoke(new SimpleModifier(){

                @Override
                protected int invoke(DatabaseLiaison liaison, Statement stmt) throws SQLException {
                    DepotMetaData.this.readVersions(liaison, stmt);
                    return 0;
                }
            });
        }
        return (curvers = this._curvers.get(pClass)) == null ? -1 : curvers;
    }

    public void initializeVersion(final String pClass) {
        this._ctx.invoke(new SimpleModifier(){

            @Override
            protected int invoke(DatabaseLiaison liaison, Statement stmt) throws SQLException {
                try {
                    return stmt.executeUpdate("insert into " + liaison.tableSQL(DepotMetaData.SCHEMA_VERSION_TABLE) + " values('" + pClass + "', 0 , 0)");
                }
                catch (SQLException e) {
                    if (liaison.isDuplicateRowException(e)) {
                        return 0;
                    }
                    throw e;
                }
            }
        });
    }

    public void updateVersion(final String pClass, final int newVersion) {
        this._ctx.invoke(new SimpleModifier(){

            @Override
            protected int invoke(DatabaseLiaison liaison, Statement stmt) throws SQLException {
                return stmt.executeUpdate("update " + liaison.tableSQL(DepotMetaData.SCHEMA_VERSION_TABLE) + "   set " + liaison.columnSQL(DepotMetaData.V_COLUMN) + " = " + newVersion + " where " + liaison.columnSQL(DepotMetaData.P_COLUMN) + " = '" + pClass + "'");
            }
        });
    }

    public boolean updateMigratingVersion(final String pClass, final int newMigratingVersion, final int guardVersion) {
        return this._ctx.invoke(new SimpleModifier(){

            @Override
            protected int invoke(DatabaseLiaison liaison, Statement stmt) throws SQLException {
                return stmt.executeUpdate("update " + liaison.tableSQL(DepotMetaData.SCHEMA_VERSION_TABLE) + "   set " + liaison.columnSQL(DepotMetaData.MV_COLUMN) + " = " + newMigratingVersion + " where " + liaison.columnSQL(DepotMetaData.P_COLUMN) + " = '" + pClass + "'" + " and " + liaison.columnSQL(DepotMetaData.MV_COLUMN) + " = " + guardVersion);
            }
        }) > 0;
    }

    public SQLBuilder getSQLBuilder(DepotTypes types, DatabaseLiaison liaison) {
        if (liaison instanceof PostgreSQLLiaison) {
            if (this._jdbcMajorVersion >= 4) {
                return new PostgreSQL4Builder(types);
            }
            return new PostgreSQLBuilder(types);
        }
        if (liaison instanceof MySQLLiaison) {
            return new MySQLBuilder(types);
        }
        if (liaison instanceof HsqldbLiaison) {
            return new HSQLBuilder(types);
        }
        throw new IllegalArgumentException("Unknown liaison type: " + liaison.getClass());
    }

    protected void readVersions(DatabaseLiaison liaison, Statement stmt) throws SQLException {
        ResultSet rs = stmt.executeQuery(" select " + liaison.columnSQL(P_COLUMN) + ", " + liaison.columnSQL(V_COLUMN) + "   from " + liaison.tableSQL(SCHEMA_VERSION_TABLE));
        while (rs.next()) {
            this._curvers.put(rs.getString(1), rs.getInt(2));
        }
    }

    protected abstract class SimpleModifier
    extends Modifier {
        protected SimpleModifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
            Statement stmt = conn.createStatement();
            try {
                int n = this.invoke(liaison, stmt);
                return n;
            }
            finally {
                stmt.close();
            }
        }

        protected abstract int invoke(DatabaseLiaison var1, Statement var2) throws SQLException;
    }
}

