/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl.operator;

import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.expression.ValueExp;
import com.samskivert.depot.impl.operator.BaseOperator;
import com.samskivert.depot.impl.operator.MultiOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Arithmetic<T extends Number>
extends MultiOperator<T> {
    public Arithmetic(SQLExpression<?> column, T value) {
        super(column, new ValueExp<T>(value));
    }

    public Arithmetic(SQLExpression<?> ... values) {
        super(values);
    }

    protected Object evaluate(Object[] ops, String name, BaseOperator.Accumulator<Double> dAcc, BaseOperator.Accumulator<Long> iAcc) {
        if (dAcc != null && Arithmetic.all(NUMERICAL, ops)) {
            return Arithmetic.accumulate(NUMERICAL, ops, 0.0, dAcc);
        }
        if (iAcc != null && Arithmetic.all(INTEGRAL, ops)) {
            return Arithmetic.accumulate(INTEGRAL, ops, 0L, iAcc);
        }
        return new SQLExpression.NoValue("Non-numeric operand for '" + name + "' (" + ops + ")");
    }
}

