/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.depot.CacheAdapter;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.Key;
import com.samskivert.depot.KeySet;
import com.samskivert.depot.Log;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.Stats;
import com.samskivert.depot.clause.FieldOverride;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.SelectClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.Fetcher;
import com.samskivert.depot.impl.KeyCacheKey;
import com.samskivert.depot.impl.Projector;
import com.samskivert.depot.impl.QueryMarshaller;
import com.samskivert.depot.impl.QueryResult;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.depot.impl.SimpleCacheKey;
import com.samskivert.jdbc.DatabaseLiaison;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FindAllQuery<T extends PersistentRecord, R>
extends Fetcher<List<R>> {
    protected Class<T> _type;
    protected QueryMarshaller<T, R> _marsh;
    protected Cloner<R> _cloner;
    protected int _cachedQueries;
    protected int _uncachedQueries;
    protected int _explicitQueries;
    protected int _cachedRecords;
    protected int _uncachedRecords;

    @Override
    public void updateStats(Stats stats) {
        stats.noteQuery(this._cachedQueries, this._uncachedQueries, this._explicitQueries, this._cachedRecords, this._uncachedRecords);
    }

    protected FindAllQuery(Class<T> type, QueryMarshaller<T, R> marsh, Cloner<R> cloner) throws DatabaseException {
        this._type = type;
        this._marsh = marsh;
        this._cloner = cloner;
    }

    protected Set<Key<T>> loadFromCache(PersistenceContext ctx, Iterable<Key<T>> allKeys, Map<Key<T>, R> entities) {
        HashSet fetchKeys = Sets.newHashSet();
        for (Key<T> key : allKeys) {
            Object value = ctx.cacheLookup(new KeyCacheKey(key));
            if (value != null) {
                R newValue = this._cloner.clone(value);
                entities.put(key, newValue);
                continue;
            }
            fetchKeys.add(key);
        }
        if (PersistenceContext.CACHE_DEBUG) {
            Log.log.info((Object)("Loaded from cache " + this._marsh.getTableName()), new Object[]{"count", entities.size()});
        }
        this._cachedRecords = entities.size();
        this._uncachedRecords = fetchKeys.size();
        return fetchKeys;
    }

    protected List<R> resolve(Iterable<Key<T>> allKeys, Map<Key<T>, R> entities) {
        ArrayList result = allKeys instanceof Collection ? Lists.newArrayListWithCapacity((int)((Collection)allKeys).size()) : Lists.newArrayList();
        for (Key<T> key : allKeys) {
            R value = entities.get(key);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    protected List<R> loadAndResolve(PersistenceContext ctx, Connection conn, Iterable<Key<T>> allKeys, Set<Key<T>> fetchKeys, Map<Key<T>, R> entities, String origStmt) throws SQLException {
        if (PersistenceContext.CACHE_DEBUG && fetchKeys.size() > 0) {
            Log.log.info((Object)("Loading " + this._marsh.getTableName()), new Object[]{"keys", this.keysToString(fetchKeys)});
        }
        if (fetchKeys.size() > Short.MAX_VALUE) {
            HashSet keys;
            int keyCount = fetchKeys.size();
            Iterator<Key<T>> iter = fetchKeys.iterator();
            do {
                keys = Sets.newHashSet();
                int nn = Math.min(keyCount, Short.MAX_VALUE);
                for (int ii = 0; ii < nn; ++ii) {
                    keys.add(iter.next());
                }
                this.loadRecords(ctx, conn, keys, entities, origStmt);
            } while ((keyCount -= keys.size()) > 0);
        } else if (fetchKeys.size() > 0) {
            this.loadRecords(ctx, conn, fetchKeys, entities, origStmt);
        }
        return this.resolve(allKeys, entities);
    }

    protected void loadRecords(PersistenceContext ctx, Connection conn, Set<Key<T>> keys, Map<Key<T>, R> entities, String origStmt) throws SQLException {
        SelectClause select = new SelectClause(this._type, this._marsh.getSelections(), new QueryClause[]{KeySet.newKeySet(this._type, keys)});
        SQLBuilder builder = ctx.getSQLBuilder(DepotTypes.getDepotTypes(ctx, select));
        builder.newQuery(select);
        HashSet got = Sets.newHashSet();
        ResultSet rs = builder.prepare(conn).executeQuery();
        int cnt = 0;
        int dups = 0;
        while (rs.next()) {
            R obj = this._marsh.createObject(rs);
            Key<T> key = this._marsh.getPrimaryKey(obj);
            if (entities.put(key, obj) != null) {
                ++dups;
            }
            ctx.cacheStore(CacheAdapter.CacheCategory.RECORD, new KeyCacheKey(key), this._cloner.clone(obj));
            got.add(key);
            ++cnt;
        }
        if (cnt > keys.size() || origStmt != null && cnt < keys.size()) {
            Log.log.warning((Object)"Row count mismatch in second pass", new Object[]{"origQuery", origStmt, "wanted", KeySet.newKeySet(this._type, keys).toString(), "got", KeySet.newKeySet(this._type, got).toString(), "dups", dups, new Exception()});
        }
        if (PersistenceContext.CACHE_DEBUG) {
            Log.log.info((Object)("Cached " + this._marsh.getTableName()), new Object[]{"count", cnt});
        }
    }

    protected String keysToString(Iterable<Key<T>> keySet) {
        StringBuilder builder = new StringBuilder("(");
        for (Key<T> key : keySet) {
            if (builder.length() > 1) {
                builder.append(", ");
            }
            key.toShortString(builder);
        }
        return builder.append(")").toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NonCloningCloner<C>
    implements Cloner<C> {
        protected NonCloningCloner() {
        }

        @Override
        public C clone(C object) {
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CloningCloner<C extends QueryResult>
    implements Cloner<C> {
        protected CloningCloner() {
        }

        @Override
        public C clone(C object) {
            QueryResult clone = ((QueryResult)object).clone();
            return (C)clone;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Cloner<C> {
        public C clone(C var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ProjectionQueryMarshaller<T extends PersistentRecord, R>
    implements QueryMarshaller<T, R> {
        protected Projector<T, R> _cset;
        protected DepotTypes _types;

        public ProjectionQueryMarshaller(Projector<T, R> cset, DepotTypes types) {
            this._cset = cset;
            this._types = types;
        }

        @Override
        public String getTableName() {
            return this._types.getTableName(this._cset.ptype);
        }

        @Override
        public SQLExpression<?>[] getSelections() {
            return this._cset.selexps;
        }

        @Override
        public Key<T> getPrimaryKey(Object object) {
            return this._types.getMarshaller(this._cset.ptype).getPrimaryKey(object);
        }

        @Override
        public R createObject(ResultSet rs) throws SQLException {
            Object[] data = new Object[this._cset.selexps.length];
            for (int ii = 0; ii < data.length; ++ii) {
                SQLExpression<?> exp = this._cset.selexps[ii];
                if (exp instanceof ColumnExp) {
                    ColumnExp col = (ColumnExp)exp;
                    data[ii] = this._types.getMarshaller(col.getPersistentClass()).getFieldMarshaller(col.name).getFromSet(rs, ii + 1);
                    continue;
                }
                data[ii] = rs.getObject(ii + 1);
            }
            return this._cset.createObject(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Projection<T extends PersistentRecord, R>
    extends FindAllQuery<T, R> {
        protected SelectClause _select;
        protected DepotTypes _types;

        public Projection(PersistenceContext ctx, Projector<T, R> cset, Iterable<? extends QueryClause> clauses) throws DatabaseException {
            super(cset.ptype, null, new NonCloningCloner());
            this._select = new SelectClause(cset.ptype, cset.selexps, clauses);
            this._types = DepotTypes.getDepotTypes(ctx, this._select);
            this._marsh = new ProjectionQueryMarshaller<T, R>(cset, this._types);
        }

        @Override
        public List<R> getCachedResult(PersistenceContext ctx) {
            return null;
        }

        @Override
        public List<R> invoke(PersistenceContext ctx, Connection conn, DatabaseLiaison liaison) throws SQLException {
            SQLBuilder builder = ctx.getSQLBuilder(this._types);
            builder.newQuery(this._select);
            ResultSet rs = builder.prepare(conn).executeQuery();
            ArrayList result = Lists.newArrayList();
            while (rs.next()) {
                result.add(this._marsh.createObject(rs));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Explicitly<T extends PersistentRecord>
    extends FullRecordQuery<T> {
        protected SelectClause _select;
        protected SimpleCacheKey _qkey;

        public Explicitly(PersistenceContext ctx, Class<T> type, Iterable<? extends QueryClause> clauses, boolean cachedContents) throws DatabaseException {
            super(ctx, type);
            this._select = new SelectClause(type, this._dmarsh.getSelections(), clauses);
            this._qkey = cachedContents ? new SimpleCacheKey(this._dmarsh.getTableName() + "Contents", this._select.toString()) : null;
        }

        @Override
        public List<T> getCachedResult(PersistenceContext ctx) {
            if (this._qkey != null) {
                ++this._cachedQueries;
                return (List)ctx.cacheLookup(this._qkey);
            }
            return null;
        }

        @Override
        public List<T> invoke(PersistenceContext ctx, Connection conn, DatabaseLiaison liaison) throws SQLException {
            ArrayList result = Lists.newArrayList();
            SQLBuilder builder = ctx.getSQLBuilder(DepotTypes.getDepotTypes(ctx, this._select));
            builder.newQuery(this._select);
            ResultSet rs = builder.prepare(conn).executeQuery();
            while (rs.next()) {
                result.add(this._dmarsh.createObject(rs));
            }
            ++this._explicitQueries;
            if (PersistenceContext.CACHE_DEBUG) {
                Log.log.info((Object)("Loaded " + this._dmarsh.getTableName()), new Object[]{"query", this._select, "rows", result.size(), "cacheKey", this._qkey});
            }
            if (this._qkey != null) {
                ctx.cacheStore(CacheAdapter.CacheCategory.RESULT, this._qkey, result);
            }
            this._uncachedRecords += result.size();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WithKeys<T extends PersistentRecord>
    extends FullRecordQuery<T> {
        protected Iterable<Key<T>> _keys;
        protected Set<Key<T>> _fetchKeys;
        protected Map<Key<T>, T> _entities = Maps.newHashMap();

        public WithKeys(PersistenceContext ctx, Iterable<Key<T>> keys) throws DatabaseException {
            super(ctx, keys.iterator().next().getPersistentClass());
            this._keys = keys;
        }

        @Override
        public List<T> getCachedResult(PersistenceContext ctx) {
            this._fetchKeys = this.loadFromCache(ctx, this._keys, this._entities);
            return this._fetchKeys.isEmpty() ? this.resolve(this._keys, this._entities) : null;
        }

        @Override
        public List<T> invoke(PersistenceContext ctx, Connection conn, DatabaseLiaison liaison) throws SQLException {
            return this.loadAndResolve(ctx, conn, this._keys, this._fetchKeys, this._entities, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WithCache<T extends PersistentRecord>
    extends FullRecordQuery<T> {
        protected SimpleCacheKey _qkey;
        protected CacheAdapter.CacheCategory _category;
        protected SelectClause _select;
        protected KeySet<T> _keys;
        protected Set<Key<T>> _fetchKeys;
        protected Map<Key<T>, T> _entities = Maps.newHashMap();

        public WithCache(PersistenceContext ctx, Class<T> type, Iterable<? extends QueryClause> clauses, DepotRepository.CacheStrategy strategy) throws DatabaseException {
            super(ctx, type);
            Preconditions.checkArgument((this._dmarsh.getComputed() == null ? 1 : 0) != 0, (Object)"This algorithm doesn't work on @Computed records.");
            for (QueryClause queryClause : clauses) {
                Preconditions.checkArgument((!(queryClause instanceof FieldOverride) ? 1 : 0) != 0, (Object)"This algorithm doesn't work with FieldOverrides.");
            }
            this._select = new SelectClause((Class<? extends PersistentRecord>)this._type, this._dmarsh.getPrimaryKeyFields(), clauses);
            switch (strategy) {
                case SHORT_KEYS: 
                case LONG_KEYS: {
                    this._qkey = new SimpleCacheKey(this._dmarsh.getTableName() + "Keys", this._select.toString());
                    this._category = strategy == DepotRepository.CacheStrategy.SHORT_KEYS ? CacheAdapter.CacheCategory.SHORT_KEYSET : CacheAdapter.CacheCategory.LONG_KEYSET;
                    break;
                }
                case RECORDS: {
                    this._qkey = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected cache strategy: " + (Object)((Object)strategy));
                }
            }
        }

        @Override
        public List<T> getCachedResult(PersistenceContext ctx) {
            if (this._qkey == null) {
                return null;
            }
            this._keys = (KeySet)ctx.cacheLookup(this._qkey);
            if (this._keys == null) {
                return null;
            }
            ++this._cachedQueries;
            this._fetchKeys = this.loadFromCache(ctx, this._keys, this._entities);
            return this._fetchKeys.size() == 0 ? this.resolve(this._keys, this._entities) : null;
        }

        @Override
        public List<T> invoke(PersistenceContext ctx, Connection conn, DatabaseLiaison liaison) throws SQLException {
            String stmtString = null;
            if (this._keys == null) {
                ArrayList keys = Lists.newArrayList();
                SQLBuilder builder = ctx.getSQLBuilder(DepotTypes.getDepotTypes(ctx, this._select));
                builder.newQuery(this._select);
                PreparedStatement stmt = builder.prepare(conn);
                stmtString = stmt.toString();
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    keys.add(this._dmarsh.makePrimaryKey(rs));
                }
                this._keys = KeySet.newKeySet(this._type, keys);
                ++this._uncachedQueries;
                if (PersistenceContext.CACHE_DEBUG) {
                    Log.log.info((Object)("Loaded " + this._dmarsh.getTableName() + " keys"), new Object[]{"query", this._select, "keys", this.keysToString(this._keys), "cached", this._qkey != null});
                }
                if (this._qkey != null) {
                    ctx.cacheStore(this._category, this._qkey, this._keys);
                }
                this._fetchKeys = this.loadFromCache(ctx, this._keys, this._entities);
            }
            return this.loadAndResolve(ctx, conn, this._keys, this._fetchKeys, this._entities, stmtString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FullRecordQuery<T extends PersistentRecord>
    extends FindAllQuery<T, T> {
        protected DepotMarshaller<T> _dmarsh;

        protected FullRecordQuery(PersistenceContext ctx, Class<T> type) {
            super(type, ctx.getMarshaller(type), new CloningCloner());
            this._dmarsh = ctx.getMarshaller(type);
        }
    }
}

