/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.expression;

import com.samskivert.depot.Ops;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.operator.Add;
import com.samskivert.depot.impl.operator.BitAnd;
import com.samskivert.depot.impl.operator.BitOr;
import com.samskivert.depot.impl.operator.Div;
import com.samskivert.depot.impl.operator.Equals;
import com.samskivert.depot.impl.operator.GreaterThan;
import com.samskivert.depot.impl.operator.GreaterThanEquals;
import com.samskivert.depot.impl.operator.In;
import com.samskivert.depot.impl.operator.IsNull;
import com.samskivert.depot.impl.operator.LessThan;
import com.samskivert.depot.impl.operator.LessThanEquals;
import com.samskivert.depot.impl.operator.Like;
import com.samskivert.depot.impl.operator.Mul;
import com.samskivert.depot.impl.operator.NotEquals;
import com.samskivert.depot.impl.operator.Sub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FluentExp<T>
implements SQLExpression<T> {
    public FluentExp<Boolean> eq(Comparable<?> value) {
        return new Equals(this, value);
    }

    public FluentExp<Boolean> eq(SQLExpression<?> expr) {
        return new Equals((SQLExpression<?>)this, expr);
    }

    public FluentExp<Boolean> notEq(Comparable<?> value) {
        return new NotEquals(this, value);
    }

    public FluentExp<Boolean> notEq(SQLExpression<?> expr) {
        return new NotEquals((SQLExpression<?>)this, expr);
    }

    public IsNull isNull() {
        return new IsNull(this);
    }

    public In in(Comparable<?> ... values) {
        return new In(this, values);
    }

    public In in(Iterable<? extends Comparable<?>> values) {
        return new In(this, values);
    }

    public FluentExp<Boolean> greaterThan(Comparable<?> value) {
        return new GreaterThan(this, value);
    }

    public FluentExp<Boolean> greaterThan(SQLExpression<?> expr) {
        return new GreaterThan((SQLExpression<?>)this, expr);
    }

    public FluentExp<Boolean> lessThan(Comparable<?> value) {
        return new LessThan(this, value);
    }

    public FluentExp<Boolean> lessThan(SQLExpression<?> expr) {
        return new LessThan((SQLExpression<?>)this, expr);
    }

    public FluentExp<Boolean> greaterEq(Comparable<?> value) {
        return new GreaterThanEquals(this, value);
    }

    public FluentExp<Boolean> greaterEq(SQLExpression<?> expr) {
        return new GreaterThanEquals((SQLExpression<?>)this, expr);
    }

    public FluentExp<Boolean> lessEq(Comparable<?> value) {
        return new LessThanEquals(this, value);
    }

    public FluentExp<Boolean> lessEq(SQLExpression<?> expr) {
        return new LessThanEquals((SQLExpression<?>)this, expr);
    }

    public FluentExp<Boolean> and(SQLExpression<Boolean> expr) {
        return Ops.and(this, expr);
    }

    public FluentExp<Boolean> or(SQLExpression<Boolean> expr) {
        return Ops.or(this, expr);
    }

    public <V extends Number> FluentExp<V> bitAnd(V value) {
        return new BitAnd<V>(this, value);
    }

    public <V extends Number> FluentExp<V> bitAnd(SQLExpression<V> expr) {
        return new BitAnd(new SQLExpression[]{this, expr});
    }

    public <V extends Number> FluentExp<V> bitOr(V value) {
        return new BitOr<V>(this, value);
    }

    public <V extends Number> FluentExp<V> bitOr(SQLExpression<V> expr) {
        return new BitOr(new SQLExpression[]{this, expr});
    }

    public <V extends Number> FluentExp<V> plus(V value) {
        return new Add<V>(this, value);
    }

    public <V extends Number> FluentExp<V> plus(SQLExpression<V> expr) {
        return new Add(new SQLExpression[]{this, expr});
    }

    public <V extends Number> FluentExp<V> minus(V value) {
        return new Sub<V>(this, value);
    }

    public <V extends Number> FluentExp<V> minus(SQLExpression<V> expr) {
        return new Sub(new SQLExpression[]{this, expr});
    }

    public <V extends Number> FluentExp<V> times(V value) {
        return new Mul<V>(this, value);
    }

    public <V extends Number> FluentExp<V> times(SQLExpression<V> expr) {
        return new Mul(new SQLExpression[]{this, expr});
    }

    public <V extends Number> FluentExp<V> div(V value) {
        return new Div<V>(this, value);
    }

    public <V extends Number> FluentExp<V> div(SQLExpression<V> expr) {
        return new Div(new SQLExpression[]{this, expr});
    }

    public FluentExp<Boolean> like(Comparable<?> value) {
        return new Like(this, value, true);
    }

    public FluentExp<Boolean> like(SQLExpression<?> expr) {
        return new Like(this, expr, true);
    }

    public FluentExp<Boolean> notLike(Comparable<?> value) {
        return new Like(this, value, false);
    }

    public FluentExp<Boolean> notLike(SQLExpression<?> expr) {
        return new Like(this, expr, false);
    }

    public FluentExp<Number> dateSub(SQLExpression<?> expr) {
        return new Sub<Number>(this, expr);
    }

    public FluentExp<Number> dateAdd(SQLExpression<?> expr) {
        return new Add<Number>(this, expr);
    }
}

