/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.depot.Transformer;
import com.samskivert.depot.annotation.Transform;
import com.samskivert.util.ByteEnumUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Transformers {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class StringBase<F>
    extends Transformer<F, String> {
        protected Type _ftype;
        protected boolean _immutable;
        protected boolean _intern;
        protected static final Interner<Iterable<String>> INTERNER = Interners.newWeakInterner();

        protected StringBase() {
        }

        @Override
        public void init(Type fieldType, Transform annotation) {
            this._ftype = fieldType;
            this._immutable = annotation.immutable();
            this._intern = annotation.intern();
        }

        @Override
        public String toPersistent(F value) {
            if (value == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            for (String s : this.asIterable(value)) {
                if (s == null) {
                    buf.append("\\\n");
                    continue;
                }
                s = s.replace("\\", "\\\\");
                s = s.replace("\n", "\\n");
                buf.append(s).append('\n');
            }
            return buf.toString();
        }

        @Override
        public F fromPersistent(String encoded) {
            if (encoded == null) {
                return null;
            }
            Builder<F> builder = this.createBuilder(encoded);
            StringBuilder buf = new StringBuilder(encoded.length());
            int nn = encoded.length();
            block8: for (int ii = 0; ii < nn; ++ii) {
                char c = encoded.charAt(ii);
                switch (c) {
                    case '\n': {
                        String s = buf.toString();
                        builder.add(this._intern ? s.intern() : s);
                        buf.setLength(0);
                        continue block8;
                    }
                    case '\\': {
                        Preconditions.checkArgument((++ii < nn ? 1 : 0) != 0, (Object)"Invalid encoded string");
                        char slashed = encoded.charAt(ii);
                        switch (slashed) {
                            case '\n': {
                                Preconditions.checkArgument((buf.length() == 0 ? 1 : 0) != 0, (Object)"Invalid encoded string");
                                builder.add(null);
                                continue block8;
                            }
                            case 'n': {
                                buf.append('\n');
                                continue block8;
                            }
                        }
                        buf.append(slashed);
                        continue block8;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            Preconditions.checkArgument((buf.length() == 0 ? 1 : 0) != 0, (Object)"Invalid encoded string");
            return builder.build();
        }

        protected abstract Iterable<String> asIterable(F var1);

        protected abstract Builder<F> createBuilder(String var1);

        protected static int countElements(String encoded) {
            int count = 0;
            int pos = 0;
            while (0 != (pos = 1 + encoded.indexOf(10, pos))) {
                ++count;
            }
            return count;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface Builder<F> {
            public void add(String var1);

            public F build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringIterable
    extends StringBase<Iterable<String>> {
        @Override
        protected Iterable<String> asIterable(Iterable<String> value) {
            return value;
        }

        @Override
        protected StringBase.Builder<Iterable<String>> createBuilder(String encoded) {
            AbstractCollection adder;
            Type clazz;
            Collection retval = null;
            Type type = clazz = this._ftype instanceof ParameterizedType ? ((ParameterizedType)this._ftype).getRawType() : this._ftype;
            if (clazz == HashSet.class || clazz == Set.class) {
                HashSet set;
                adder = set = Sets.newHashSet();
                if (this._immutable && clazz == Set.class) {
                    retval = Collections.unmodifiableSet(set);
                }
            } else if (clazz == LinkedList.class) {
                adder = Lists.newLinkedList();
            } else {
                ArrayList list = Lists.newArrayList();
                adder = list;
                if (this._immutable && (clazz == List.class || clazz == Iterable.class || clazz == Collection.class)) {
                    retval = Collections.unmodifiableList(list);
                }
            }
            return this.createBuilder(adder, (Collection<String>)(retval == null ? adder : retval));
        }

        protected StringBase.Builder<Iterable<String>> createBuilder(final Collection<String> adder, final Collection<String> retval) {
            Preconditions.checkNotNull(adder);
            return new StringBase.Builder<Iterable<String>>(){

                @Override
                public void add(String s) {
                    adder.add(s);
                }

                @Override
                public Iterable<String> build() {
                    return StringIterable.this._immutable && StringIterable.this._intern && adder != retval ? (Iterable)StringBase.INTERNER.intern((Object)retval) : retval;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringArray
    extends StringBase<String[]> {
        @Override
        protected Iterable<String> asIterable(String[] value) {
            return Arrays.asList(value);
        }

        @Override
        protected StringBase.Builder<String[]> createBuilder(String encoded) {
            final String[] result = new String[StringArray.countElements(encoded)];
            return new StringBase.Builder<String[]>(){
                protected int idx = 0;

                @Override
                public void add(String s) {
                    result[this.idx++] = s;
                }

                @Override
                public String[] build() {
                    return result;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteEnumSet<E extends Enum<E>>
    extends Transformer<Set<E>, Integer> {
        protected Class<E> _eclass;

        @Override
        public void init(Type fieldType, Transform annotation) {
            this._eclass = (Class)((ParameterizedType)fieldType).getActualTypeArguments()[0];
        }

        @Override
        public Integer toPersistent(Set<E> value) {
            return value == null ? null : Integer.valueOf(ByteEnumUtil.setToInt(value));
        }

        @Override
        public Set<E> fromPersistent(Integer encoded) {
            return encoded == null ? null : ByteEnumUtil.intToSet(this._eclass, (int)encoded);
        }
    }
}

